<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Giveaway extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'status',
        'keyword',
        'winners_count',
        'winners',
        'started_at',
        'ended_at',
    ];

    protected function casts(): array
    {
        return [
            'winners' => 'array',
            'started_at' => 'datetime',
            'ended_at' => 'datetime',
        ];
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function entries()
    {
        return $this->hasMany(GiveawayEntry::class);
    }

    public function isActive(): bool
    {
        return $this->status === 'active';
    }

    public function pickWinners(): array
    {
        $allEntries = $this->entries()->get()->shuffle();
        $winnerCount = min($this->winners_count, $allEntries->count());

        $winners = $allEntries->take($winnerCount)->pluck('user_name')->toArray();

        $this->update([
            'status' => 'completed',
            'winners' => $winners,
            'ended_at' => now(),
        ]);

        return $winners;
    }
}
