<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('commands', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->string('name'); // e.g., "discord", "socials"
            $table->text('response');
            $table->integer('cooldown_sec')->default(5);
            $table->enum('required_role', ['owner', 'admin', 'mod', 'trusted', 'viewer'])->default('viewer');
            $table->boolean('is_enabled')->default(true);
            $table->json('aliases')->nullable(); // ["disc", "dc"]
            $table->json('variables')->nullable(); // custom variables
            $table->integer('use_count')->default(0);
            $table->timestamp('last_used_at')->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'name']);
            $table->index(['tenant_id', 'is_enabled']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('commands');
    }
};
