<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('timers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->text('message');
            $table->integer('interval_min')->default(10); // fire every X minutes
            $table->integer('chat_activity_window_min')->default(10); // only fire if chat active
            $table->boolean('is_enabled')->default(true);
            $table->timestamp('last_fired_at')->nullable();
            $table->timestamp('next_fire_at')->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'is_enabled']);
            $table->index('next_fire_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('timers');
    }
};
