<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('filters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->enum('type', ['caps', 'symbols', 'links', 'blacklist', 'emoji'])->default('caps');
            $table->integer('threshold')->default(50); // percentage for caps/symbols
            $table->enum('action', ['warn', 'timeout', 'ignore'])->default('warn');
            $table->json('list')->nullable(); // blacklist words or allowed domains
            $table->boolean('is_enabled')->default(true);
            $table->timestamps();

            $table->index(['tenant_id', 'type']);
            $table->index(['tenant_id', 'is_enabled']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('filters');
    }
};
