<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('messages_log', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->string('msg_id')->unique(); // YouTube message ID
            $table->string('author_channel_id');
            $table->string('author_name');
            $table->text('text');
            $table->string('detected_lang', 10)->nullable(); // ISO code
            $table->json('classification')->nullable(); // {is_question: bool, intent: string}
            $table->enum('handled_by', ['openai', 'command', 'timer', 'filter', 'ignored'])->nullable();
            $table->text('posted_reply')->nullable();
            $table->json('error')->nullable();
            $table->timestamp('created_at');

            $table->index(['tenant_id', 'created_at']);
            $table->index('msg_id');
            $table->index(['tenant_id', 'author_channel_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('messages_log');
    }
};
