<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('role_overrides', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->string('youtube_user_id'); // YouTube channel ID
            $table->string('youtube_user_name');
            $table->enum('role', ['owner', 'admin', 'mod', 'trusted', 'viewer'])->default('viewer');
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'youtube_user_id']);
            $table->unique(['tenant_id', 'youtube_user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('role_overrides');
    }
};
