@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-8">
        <h2 class="text-3xl font-bold text-white">Dashboard</h2>
        <p class="mt-2 text-gray-400">Manage your YouTube chatbot instances</p>
    </div>

    <!-- Connect YouTube Button -->
    @if($tenants->isEmpty())
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl p-8 mb-6 shadow-2xl">
        <div class="text-center max-w-md mx-auto">
            <div class="bg-gradient-to-r from-indigo-500 to-purple-600 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
            <h3 class="text-xl font-semibold text-white mb-2">Get Started with PXEBot</h3>
            <p class="text-gray-400 mb-6">Connect your YouTube channel to start using AI-powered chat moderation and commands</p>
            <a href="{{ route('oauth.google.redirect') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-500 hover:to-red-600 text-white font-semibold rounded-lg shadow-lg transform hover:scale-105 transition-all duration-200">
                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M21.582 6.186c-.23-1.043-1.046-1.85-2.089-2.079C17.63 3.5 12 3.5 12 3.5s-5.63 0-7.493.607c-1.043.229-1.859 1.036-2.089 2.079C2 8.049 2 12 2 12s0 3.951.418 5.814c.23 1.043 1.046 1.85 2.089 2.079C6.37 20.5 12 20.5 12 20.5s5.63 0 7.493-.607c1.043-.229 1.859-1.036 2.089-2.079C22 15.951 22 12 22 12s0-3.951-.418-5.814zM10 15V9l5 3-5 3z"/>
                </svg>
                Connect YouTube Channel
            </a>
        </div>
    </div>
    @else
    <div class="mb-6">
        <a href="{{ route('oauth.google.redirect') }}" class="inline-flex items-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-500 hover:to-red-600 text-white font-medium rounded-lg shadow-lg transform hover:scale-105 transition-all duration-200">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
            </svg>
            Add Another Channel
        </a>
    </div>
    @endif

    <!-- Tenants List -->
    @foreach($dashboardData as $data)
    @php
        $tenant = $data['tenant'];
        $stats = $data['stats'];
        $quota = $data['quota'];
        $roastingMode = $data['roasting_mode'];
    @endphp
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl overflow-hidden shadow-2xl mb-6 hover:border-gray-600 transition-colors">
        <!-- Header -->
        <div class="p-6 border-b border-gray-700">
            <div class="flex flex-col sm:flex-row sm:justify-between sm:items-start gap-4">
                <div class="flex-1">
                    <h3 class="text-xl font-semibold text-white mb-1">{{ $tenant->channel_title }}</h3>
                    <p class="text-sm text-gray-400">Channel ID: <span class="font-mono">{{ $tenant->channel_id }}</span></p>
                </div>
                <div class="flex items-center space-x-2">
                    <span class="px-4 py-2 rounded-full text-xs font-bold {{ $tenant->status === 'running' ? 'bg-green-500/20 text-green-400 border border-green-500/30' : ($tenant->status === 'error' ? 'bg-red-500/20 text-red-400 border border-red-500/30' : 'bg-gray-500/20 text-gray-400 border border-gray-500/30') }}">
                        <span class="inline-block w-2 h-2 rounded-full mr-2 {{ $tenant->status === 'running' ? 'bg-green-400 animate-pulse' : ($tenant->status === 'error' ? 'bg-red-400' : 'bg-gray-400') }}"></span>
                        {{ strtoupper($tenant->status) }}
                    </span>
                </div>
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 p-6 bg-gray-800/50">
            <div class="bg-gray-900/50 p-4 rounded-lg border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <div class="text-xs text-gray-400 uppercase tracking-wide">Messages (1min)</div>
                    <svg class="w-4 h-4 text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z" />
                    </svg>
                </div>
                <div class="text-2xl font-bold text-white">{{ $stats['last_1min'] }}</div>
            </div>

            <div class="bg-gray-900/50 p-4 rounded-lg border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <div class="text-xs text-gray-400 uppercase tracking-wide">Messages (5min)</div>
                    <svg class="w-4 h-4 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                    </svg>
                </div>
                <div class="text-2xl font-bold text-white">{{ $stats['last_5min'] }}</div>
            </div>

            <div class="bg-gray-900/50 p-4 rounded-lg border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <div class="text-xs text-gray-400 uppercase tracking-wide">Unique Viewers</div>
                    <svg class="w-4 h-4 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                </div>
                <div class="text-2xl font-bold text-white">{{ $stats['unique_viewers_1h'] }}</div>
            </div>

            <div class="bg-gray-900/50 p-4 rounded-lg border border-gray-700">
                <div class="flex items-center justify-between mb-2">
                    <div class="text-xs text-gray-400 uppercase tracking-wide">Quota Remaining</div>
                    <svg class="w-4 h-4 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                </div>
                <div class="text-2xl font-bold text-white">{{ $quota['per_minute']['remaining'] }}/min</div>
            </div>
        </div>

        <!-- Error Alert -->
        @if($tenant->last_error)
        <div class="mx-6 my-4 bg-red-900/30 border border-red-500/50 rounded-lg p-4">
            <div class="flex items-start space-x-3">
                <svg class="w-5 h-5 text-red-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                </svg>
                <div class="flex-1">
                    <p class="text-sm text-red-200 font-medium">{{ $tenant->last_error }}</p>
                    <p class="text-xs text-red-300/70 mt-1">{{ $tenant->last_error_at->diffForHumans() }}</p>
                </div>
            </div>
        </div>
        @endif

        <!-- Actions -->
        <div class="p-6 bg-gray-800/30 border-t border-gray-700">
            <div class="flex flex-wrap gap-3">
                @if($tenant->status !== 'running')
                <form method="POST" action="{{ route('tenant.start', $tenant) }}">
                    @csrf
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                        </svg>
                        Start Bot
                    </button>
                </form>
                @else
                <form method="POST" action="{{ route('tenant.stop', $tenant) }}">
                    @csrf
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                        Stop Bot
                    </button>
                </form>
                @endif

                <a href="{{ route('tenant.commands.index', $tenant) }}" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                    Commands
                </a>

                <a href="{{ route('tenant.timers.index', $tenant) }}" class="inline-flex items-center px-4 py-2 bg-purple-600 hover:bg-purple-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Timers
                </a>

                <!-- Roasting Mode Toggle -->
                <div x-data="{
                    enabled: {{ $roastingMode ? 'true' : 'false' }},
                    loading: false,
                    toggle() {
                        this.loading = true;
                        fetch('{{ route('tenant.settings.toggle', [$tenant, 'roasting_mode']) }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            }
                        })
                        .then(res => res.json())
                        .then(data => {
                            this.enabled = data.enabled;
                            this.loading = false;
                        })
                        .catch(err => {
                            console.error(err);
                            this.loading = false;
                        });
                    }
                }" class="flex items-center space-x-3 px-4 py-2 bg-gray-700/50 rounded-lg border border-gray-600">
                    <button @click="toggle()" :disabled="loading" type="button" class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors focus:outline-none focus:ring-2 focus:ring-orange-500 focus:ring-offset-2 focus:ring-offset-gray-800" :class="enabled ? 'bg-orange-600' : 'bg-gray-600'">
                        <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform" :class="enabled ? 'translate-x-6' : 'translate-x-1'"></span>
                    </button>
                    <div class="flex items-center space-x-2">
                        <span class="text-sm font-medium text-white">🔥 Roasting Mode</span>
                        <span x-show="loading" class="text-xs text-gray-400">(saving...)</span>
                    </div>
                </div>

                <form method="POST" action="{{ route('tenant.destroy', $tenant) }}" onsubmit="return confirm('Are you sure you want to disconnect this channel?');" class="ml-auto">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-gray-300 rounded-lg font-medium transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                        </svg>
                        Disconnect
                    </button>
                </form>
            </div>
        </div>
    </div>
    @endforeach
</div>
@endsection
