# PXEBot - cPanel Deployment Checklist

## ⚠️ CRITICAL: Read This First
**Shared hosting (cPanel) will have LIMITED functionality!**
- ✅ User registration, login, dashboard will work
- ❌ YouTube chat polling will NOT work (requires background processes)
- ❌ Bot auto-replies will NOT work (requires queue workers)
- ❌ Laravel Horizon will NOT work

**Recommended: Use VPS hosting instead ($5/month DigitalOcean, Vultr, Linode)**

---

## Pre-Deployment Checklist

### 1. Get Google OAuth Credentials (REQUIRED)
- [ ] Go to: https://console.cloud.google.com/apis/credentials
- [ ] Create new project: "PXEBot Production"
- [ ] Enable YouTube Data API v3
- [ ] Create OAuth 2.0 Client ID
- [ ] Add authorized redirect URI: `https://phxbot.com/oauth/google/callback`
- [ ] Copy Client ID and Client Secret

### 2. Get OpenAI API Key (REQUIRED)
- [ ] Go to: https://platform.openai.com/api-keys
- [ ] Create new API key
- [ ] Copy the key (starts with `sk-proj-...`)

### 3. Update .env.production File
- [ ] Open `.env.production` in text editor
- [ ] Update database credentials (will get from cPanel in step 4):
  ```
  DB_HOST=localhost
  DB_DATABASE=phxbot_pxebot
  DB_USERNAME=phxbot_user
  DB_PASSWORD=your_password_here
  ```
- [ ] Add your Google OAuth credentials:
  ```
  YT_CLIENT_ID=your-client-id.apps.googleusercontent.com
  YT_CLIENT_SECRET=your-client-secret
  ```
- [ ] Add your OpenAI API key:
  ```
  OPENAI_API_KEY=sk-proj-your-key-here
  ```
- [ ] Save the file

### 4. cPanel Database Setup
- [ ] Login to cPanel at your hosting provider
- [ ] Go to **MySQL Databases**
- [ ] Create new database:
  - Database name: `pxebot` (will become `phxbot_pxebot`)
  - Click "Create Database"
- [ ] Create new database user:
  - Username: `user` (will become `phxbot_user`)
  - Password: Generate strong password or create your own
  - Click "Create User"
- [ ] Add user to database:
  - Select user: `phxbot_user`
  - Select database: `phxbot_pxebot`
  - Check "ALL PRIVILEGES"
  - Click "Add"
- [ ] **IMPORTANT:** Note down these credentials to update .env.production

---

## Deployment Steps

### Step 1: Upload Files

**Option A: FTP (Recommended)**
1. [ ] Use FileZilla or Cyberduck
2. [ ] Connect to your cPanel FTP
3. [ ] Navigate to `/public_html/`
4. [ ] Create folder: `pxebot`
5. [ ] Upload entire project to `/public_html/pxebot/`
6. [ ] Upload time: ~5-10 minutes (depends on connection speed)

**Option B: cPanel File Manager**
1. [ ] Create ZIP file of entire project
2. [ ] Login to cPanel → File Manager
3. [ ] Navigate to `public_html`
4. [ ] Upload ZIP file
5. [ ] Extract ZIP file
6. [ ] Rename folder to `pxebot`

### Step 2: Rename Environment File
- [ ] In cPanel File Manager or FTP:
  - Navigate to `/public_html/pxebot/`
  - Rename `.env.production` to `.env`
  - Verify all credentials are correct in the file

### Step 3: Set File Permissions
- [ ] Right-click `storage` folder → Permissions → Set to `755`
- [ ] Right-click `bootstrap/cache` folder → Permissions → Set to `755`
- [ ] If permissions don't work via File Manager, ask hosting support for SSH access

### Step 4: Change Domain Document Root
- [ ] cPanel → **Domains**
- [ ] Click on domain: `phxbot.com`
- [ ] Change **Document Root** to: `/public_html/pxebot/public`
- [ ] Click "Save"
- [ ] Wait 1-2 minutes for change to propagate

### Step 5: Run Database Migrations

**If SSH access available:**
```bash
cd /home/phxbot/public_html/pxebot
php artisan migrate --force
php artisan storage:link
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

**If NO SSH access:**
- [ ] Contact hosting support to enable "Terminal" in cPanel
- [ ] Use cPanel Terminal to run above commands
- [ ] OR ask support to run migrations for you

### Step 6: Test the Application
- [ ] Visit: https://phxbot.com
- [ ] Should see PXEBot homepage
- [ ] Click "Register" → Create account
- [ ] Login to dashboard
- [ ] Click "Connect YouTube" → Should redirect to Google OAuth
- [ ] Accept permissions → Should return to dashboard

---

## What Will Work vs. What Won't

### ✅ WILL WORK on Shared Hosting:
- User registration and login
- Dashboard display
- Settings management
- YouTube OAuth connection (one-time setup)
- Database storage

### ❌ WILL NOT WORK on Shared Hosting:
- **YouTube chat polling** (requires background process)
- **Bot auto-replies** (requires queue workers)
- **Timers** (requires Laravel scheduler)
- **Real-time monitoring** (requires Horizon)
- **Giveaways** (requires active polling)

**The bot can store configurations but CANNOT actively monitor/respond to YouTube chats on shared hosting.**

---

## Troubleshooting

### Error: "500 Internal Server Error"
- Check file permissions (storage and bootstrap/cache should be 755)
- Check .env file exists and has correct database credentials
- Check error logs in cPanel → Error Log

### Error: "Database connection failed"
- Verify database name includes your cPanel username prefix (e.g., `phxbot_pxebot`)
- Verify database user has ALL privileges
- Check DB_HOST is `localhost` in .env

### Error: "404 Not Found" on all pages
- Verify document root is set to `/public_html/pxebot/public`
- Verify .htaccess file exists in public folder
- Check if mod_rewrite is enabled (ask hosting support)

### OAuth redirect error
- Verify redirect URI in Google Cloud Console matches: `https://phxbot.com/oauth/google/callback`
- Ensure no extra spaces or typos in .env credentials

---

## Migration to VPS (Recommended)

For full functionality, deploy to VPS instead:

1. **DigitalOcean** ($5/month): https://www.digitalocean.com/
2. **Vultr** ($5/month): https://www.vultr.com/
3. **Linode** ($5/month): https://www.linode.com/
4. **AWS Lightsail** ($5/month): https://aws.amazon.com/lightsail/

See `DEPLOYMENT.md` for VPS deployment instructions.

---

## Support Files
- `DEPLOYMENT_CPANEL.md` - Detailed cPanel deployment guide
- `DEPLOYMENT.md` - VPS deployment guide
- `README.md` - Complete project documentation
- `.env.production` - Production environment template

---

## Final Notes

✅ **Before uploading to cPanel:**
1. Get Google OAuth credentials
2. Get OpenAI API key
3. Update .env.production with all credentials
4. Create database in cPanel
5. Note database credentials

⚠️ **Remember:** This is a bot designed for VPS hosting. Shared hosting deployment is possible but will have severely limited functionality.

🚀 **For production use:** Migrate to VPS for full bot functionality including YouTube chat monitoring, auto-replies, timers, and giveaways.
