# PXEBot - Windows VPS Setup Guide

## Fast YouTube Chat Bot Configuration

This guide will help you set up PXEBot on Windows VPS for **FAST** message reading and replying (1 second polling interval).

---

## ✅ What's Been Configured

- **Scheduler**: Now polls YouTube chat **every 1 second** (changed from 2 seconds)
- **Queue Worker**: Processes jobs immediately with no sleep delay
- **Auto-restart**: Queue worker automatically restarts if it crashes

---

## 📋 Setup Steps

### Step 1: Start the Queue Worker

**Option A: Manual Start (Quick Test)**

1. Double-click `start-bot.bat` file
2. Keep the window OPEN (minimize it, don't close)
3. This will process all YouTube messages

**Option B: Run as Background Process (Recommended)**

1. Open Command Prompt as Administrator
2. Navigate to project folder:
   ```cmd
   cd C:\xampp\htdocs\phxbot.com
   ```
3. Run in minimized window:
   ```cmd
   start /min queue-worker.bat
   ```

---

### Step 2: Setup Windows Task Scheduler (for Laravel Scheduler)

The scheduler runs the polling job every second. Follow these steps:

#### Create Task in Task Scheduler:

1. **Open Task Scheduler**
   - Press `Win + R`
   - Type `taskschd.msc`
   - Press Enter

2. **Create New Task**
   - Click "Create Task" (not "Create Basic Task")
   - Name: `PXEBot Scheduler`
   - Description: `Laravel scheduler for PXEBot - runs every minute`
   - Check: "Run whether user is logged on or not"
   - Check: "Run with highest privileges"

3. **Triggers Tab**
   - Click "New..."
   - Begin the task: `On a schedule`
   - Settings: `Daily`
   - Start: `12:00:00 AM` (or any time)
   - Recur every: `1 days`
   - Check: "Repeat task every" → `1 minute`
   - For a duration of: `Indefinitely`
   - Check: "Enabled"
   - Click OK

4. **Actions Tab**
   - Click "New..."
   - Action: `Start a program`
   - Program/script: `C:\xampp\htdocs\phxbot.com\scheduler.bat`
   - Start in: `C:\xampp\htdocs\phxbot.com`
   - Click OK

5. **Conditions Tab**
   - UNCHECK: "Start the task only if the computer is on AC power"
   - UNCHECK: "Stop if the computer switches to battery power"

6. **Settings Tab**
   - Check: "Allow task to be run on demand"
   - Check: "Run task as soon as possible after a scheduled start is missed"
   - Check: "If the task fails, restart every" → `1 minute`
   - Check: "Stop the task if it runs longer than" → `3 days`
   - Click OK

7. **Save Task**
   - Enter Windows administrator password if prompted

8. **Test the Task**
   - Right-click on "PXEBot Scheduler"
   - Click "Run"
   - Check `storage\logs\scheduler.log` to confirm it's working

---

### Step 3: Setup Queue Worker as Windows Service (Optional but Recommended)

To keep the queue worker running even after server restart:

#### Using NSSM (Non-Sucking Service Manager):

1. **Download NSSM**
   - Visit: https://nssm.cc/download
   - Download and extract to `C:\nssm\`

2. **Install Service**
   - Open Command Prompt as Administrator
   - Run:
     ```cmd
     cd C:\nssm\win64
     nssm install PXEBotWorker "C:\xampp\htdocs\phxbot.com\queue-worker.bat"
     ```

3. **Configure Service**
   - The NSSM GUI will open
   - **Application tab**:
     - Path: `C:\xampp\htdocs\phxbot.com\queue-worker.bat`
     - Startup directory: `C:\xampp\htdocs\phxbot.com`
   - **Details tab**:
     - Display name: `PXEBot Queue Worker`
     - Description: `PXEBot YouTube Chat Bot Queue Worker`
     - Startup type: `Automatic`
   - Click "Install service"

4. **Start Service**
   ```cmd
   nssm start PXEBotWorker
   ```

5. **Check Service Status**
   ```cmd
   nssm status PXEBotWorker
   ```

6. **Service Commands**
   ```cmd
   REM Start service
   nssm start PXEBotWorker

   REM Stop service
   nssm stop PXEBotWorker

   REM Restart service
   nssm restart PXEBotWorker

   REM Remove service (if needed)
   nssm remove PXEBotWorker confirm
   ```

---

## 🚀 Verify Everything is Working

### 1. Check Task Scheduler
```cmd
REM View last run time
schtasks /query /tn "PXEBot Scheduler" /v /fo list
```

### 2. Check Queue Worker
```cmd
REM If running as service
nssm status PXEBotWorker

REM If running manually, check if process is running
tasklist | findstr php.exe
```

### 3. Check Logs
- Scheduler log: `storage\logs\scheduler.log`
- Laravel log: `storage\logs\laravel.log`
- Queue worker output: Check the command window

### 4. Test the Bot
1. Go to your website: https://phxbot.com
2. Login to dashboard
3. Click "Start Bot"
4. Go to your YouTube live stream
5. Type a message in chat
6. Bot should respond within **1-2 seconds**

---

## 📊 Performance Settings

Current configuration for **FAST** responses:

### Scheduler (Kernel.php)
- YouTube polling: **Every 1 second**
- Timers: Every 1 minute
- Token refresh: Every 10 minutes

### Queue Worker (queue-worker.bat)
- Sleep time: **0 seconds** (instant processing)
- Timeout: 90 seconds per job
- Tries: 3 attempts
- Max time: 1 hour (then auto-restart)

### Environment Variables (.env)
```env
# Polling speed
YT_POLL_INTERVAL_SECONDS=1

# Rate limiting (to prevent YouTube API quota exhaustion)
RATE_LIMIT_OUTBOUND_PER_MIN=12
RATE_LIMIT_OUTBOUND_PER_HOUR=200

# Queue
QUEUE_CONNECTION=database
```

---

## 🔧 Troubleshooting

### Bot Not Responding to Messages

**Check 1: Is Queue Worker Running?**
```cmd
tasklist | findstr php.exe
```
If not running, start it with `start-bot.bat`

**Check 2: Is Task Scheduler Running?**
```cmd
schtasks /query /tn "PXEBot Scheduler"
```

**Check 3: Check for Errors**
Look at: `storage\logs\laravel.log`

**Check 4: Clear Cache**
```cmd
cd C:\xampp\htdocs\phxbot.com
C:\xampp\php\php.exe artisan cache:clear
C:\xampp\php\php.exe artisan config:clear
```

### Slow Response Times

**Solution 1: Check Queue Jobs**
```cmd
C:\xampp\php\php.exe artisan queue:work --once
```
If jobs are piling up, increase worker count by running multiple `queue-worker.bat` instances.

**Solution 2: Check YouTube API Quota**
- Visit Google Cloud Console
- Check if quota limit is reached
- Daily limit: 10,000 units

**Solution 3: Reduce Polling Interval**
Already set to 1 second. Can't go faster without hitting YouTube rate limits.

### Memory Leaks

If PHP memory keeps increasing:

**Solution: Restart Queue Worker Periodically**

Edit `queue-worker.bat` and change:
```bat
C:\xampp\php\php.exe artisan queue:work database --tries=3 --max-time=1800 --sleep=0
```
This restarts worker every 30 minutes (1800 seconds).

---

## 📝 Maintenance Commands

### Clear Old Logs
```cmd
cd C:\xampp\htdocs\phxbot.com
C:\xampp\php\php.exe artisan model:prune
```

### Restart Everything
```cmd
REM Stop queue worker
taskkill /F /IM php.exe

REM Start queue worker
start /min queue-worker.bat

REM Force run scheduler
C:\xampp\php\php.exe artisan schedule:run
```

### Check Database Queue
```cmd
C:\xampp\php\php.exe artisan queue:failed
```

### Retry Failed Jobs
```cmd
C:\xampp\php\php.exe artisan queue:retry all
```

---

## 🎯 Performance Metrics

With current setup, you should expect:

- **Message Detection**: 1-2 seconds
- **Bot Response**: 2-3 seconds total
- **CPU Usage**: 5-15% (single core)
- **Memory Usage**: 50-100 MB per queue worker
- **API Calls**: ~30 per minute when active

---

## ✅ Final Checklist

- [ ] Task Scheduler running every 1 minute
- [ ] Queue worker running (manual or service)
- [ ] MySQL service running
- [ ] Apache/Nginx running (for web dashboard)
- [ ] Bot status = "running" in dashboard
- [ ] YouTube OAuth connected
- [ ] OpenAI API key configured

---

## 🆘 Support

If you encounter issues:

1. Check logs in `storage\logs\`
2. Verify all services are running
3. Test manually: `php artisan bot:control status`
4. Check Windows Event Viewer for service errors

---

**Setup Complete! Your bot is now running with 1-second fast polling. 🚀**
