# YouTube API ToS Compliance - Resolution Summary

**Date:** November 10, 2025
**Project:** PHXBot (T2Plays)
**Project Number:** 462694888013
**Report:** ToS Violations Report V.1

---

## Violations Resolved

### ✅ 1. Multiple Project Numbers (III.D.1c)
**Status:** Confirmed
**Response:** This project uses only ONE project number: **462694888013**

---

### ✅ 2. Terms of Service Requirements (III.A.1)

**Violation:** API Clients did not state that users agree to YouTube ToS

**Resolution:**
- Created comprehensive Terms of Service page at `/terms-of-service`
- Added prominent notice stating: "By using PHXBot, you are also agreeing to be bound by the YouTube Terms of Service"
- Added footer link on all pages referencing YouTube ToS
- Direct link to YouTube ToS: https://www.youtube.com/t/terms

**Files Modified:**
- `resources/views/pages/terms-of-service.blade.php` (NEW)
- `resources/views/layouts/app.blade.php` (footer updated)
- `routes/web.php` (route added)

---

### ✅ 3. Privacy Policy Requirements (III.A.2a-2i)

**Previous Issues:**
- No privacy policy
- Missing YouTube API Services disclosure
- No Google Privacy Policy link
- No data collection/usage explanation
- No data sharing disclosure
- No cookie disclosure
- No data deletion procedure
- No contact information

**Resolution:**
Created comprehensive Privacy Policy at `/privacy-policy` including ALL required sections:

#### Section 1: Introduction
- States use of YouTube API Services
- Links to Google Privacy Policy

#### Section 2: Information We Collect
- YouTube Data (via YouTube API Services)
- Account Information
- Usage Data
- **Cookies and Similar Technologies** (III.A.2g compliance)

#### Section 3: How We Use Your Information
- Detailed explanation of data usage purposes

#### Section 4: How We Process and Share Information
- Internal processing details
- Third-party services (Google/YouTube, OpenAI)
- What data is NOT shared

#### Section 5: Data Storage and Security
- Security measures implemented

#### Section 6: Your Data Rights
- **Data Deletion Procedures** (III.A.2h compliance)
  - How to disconnect YouTube channel
  - How to request account deletion
  - Link to Google security settings: https://myaccount.google.com/connections?filters=3,4&hl=en
- Data retention policy (30 days)

#### Section 7: YouTube API Services
- Links to YouTube Terms of Service
- Links to Google Privacy Policy

#### Section 10: Contact Us (III.A.2i compliance)
- Email: support@phxbot.com
- Website: https://phxbot.com
- Contact page link

**Files Created:**
- `resources/views/pages/privacy-policy.blade.php` (NEW)
- `routes/web.php` (route added)

---

### ✅ 4. Contact Information (III.A.2i)

**Violation:** API Client does not provide contact information

**Resolution:**
Created dedicated Contact page at `/contact` with:
- Email: support@phxbot.com
- Website: https://phxbot.com
- Business information
- Developer information
- Support topics
- Quick links to all policies

**Files Created:**
- `resources/views/pages/contact.blade.php` (NEW)
- `app/Http/Controllers/PageController.php` (NEW)
- `routes/web.php` (route added)

---

### ✅ 5. YouTube Branding Violations (III.F.2.a-b)

**Violation:** YouTube logos and icons did not follow branding guidelines

**Issues Found:**
1. Custom SVG implementation of YouTube logo in "Connect YouTube Channel" button
2. Non-compliant color scheme
3. Incorrect logo usage

**Resolution:**
- **Replaced custom YouTube logo SVG with official Google sign-in button**
- Updated button text from "Connect YouTube Channel" to "Sign in with Google"
- Implemented proper Google branding colors (#4285F4, #34A853, #FBBC05, #EA4335)
- Follows Google Identity branding guidelines

**Files Modified:**
- `resources/views/dashboard/index.blade.php` (lines 19-28, 57-66, 122-131)
  - Line 19-28: Empty state "Sign in with Google" button
  - Line 57-66: "Add Google Account" button (for adding additional channels)
  - Line 122-131: "Reconnect with Google" button (for OAuth errors)
- `resources/views/welcome.blade.php` (line 150-155)

**Branding Resources Referenced:**
- https://developers.google.com/youtube/terms/branding-guidelines
- https://www.youtube.com/howyoutubeworks/resources/brand-resources/

---

## New Routes Added

```php
// Policy pages (public)
Route::get('/privacy-policy', [PageController::class, 'privacyPolicy'])->name('privacy-policy');
Route::get('/terms-of-service', [PageController::class, 'termsOfService'])->name('terms-of-service');
Route::get('/contact', [PageController::class, 'contact'])->name('contact');
```

---

## Footer Updates

All pages now include links to:
- Privacy Policy
- Terms of Service
- Contact Us
- YouTube ToS (external link)
- Statement: "By using PHXBot, you agree to the YouTube Terms of Service"

---

## Next Steps for Google OAuth Consent Screen

When updating your Google Cloud Console OAuth consent screen, use these URLs:

1. **Privacy Policy URL:**
   `https://phxbot.com/privacy-policy`

2. **Terms of Service URL:**
   `https://phxbot.com/terms-of-service`

3. **Homepage URL:**
   `https://phxbot.com`

4. **Support Email:**
   `support@phxbot.com`

### How to Update OAuth Consent Screen:

1. Go to: https://console.cloud.google.com/apis/credentials/consent
2. Select project: **462694888013**
3. Click "EDIT APP"
4. Update the following fields:
   - **App name:** PHXBot
   - **User support email:** support@phxbot.com
   - **App logo:** (optional, must follow guidelines)
   - **Application home page:** https://phxbot.com
   - **Application privacy policy link:** https://phxbot.com/privacy-policy
   - **Application terms of service link:** https://phxbot.com/terms-of-service
   - **Authorized domains:** phxbot.com
   - **Developer contact email:** support@phxbot.com
5. Save changes

---

## Summary of Compliance

| Policy Section | Requirement | Status | File/Location |
|---------------|-------------|---------|---------------|
| III.D.1c | Confirm project numbers | ✅ Complete | Single project: 462694888013 |
| III.A.1 | YouTube ToS reference in our ToS | ✅ Complete | `/terms-of-service` |
| III.A.2a | Privacy policy exists | ✅ Complete | `/privacy-policy` |
| III.A.2b | YouTube API Services disclosure | ✅ Complete | Privacy Policy §1, §7 |
| III.A.2c | Google Privacy Policy link | ✅ Complete | Privacy Policy §1, §7 |
| III.A.2d | Data collection explanation | ✅ Complete | Privacy Policy §2 |
| III.A.2e | Data usage/sharing explanation | ✅ Complete | Privacy Policy §3, §4 |
| III.A.2g | Cookie disclosure | ✅ Complete | Privacy Policy §2.4 |
| III.A.2h | Data deletion procedure | ✅ Complete | Privacy Policy §6.2 |
| III.A.2i | Contact information | ✅ Complete | `/contact` + all pages footer |
| III.F.2.a-b | YouTube branding compliance | ✅ Complete | Dashboard + Welcome page |

---

## Files Created/Modified

### New Files:
1. `resources/views/pages/privacy-policy.blade.php`
2. `resources/views/pages/terms-of-service.blade.php`
3. `resources/views/pages/contact.blade.php`
4. `app/Http/Controllers/PageController.php`

### Modified Files:
1. `routes/web.php` - Added public routes for policy pages
2. `resources/views/layouts/app.blade.php` - Updated footer with policy links
3. `resources/views/dashboard/index.blade.php` - Fixed YouTube branding, updated buttons
4. `resources/views/welcome.blade.php` - Added navigation links and footer with policy pages

---

## Verification Checklist

- [x] Privacy Policy page accessible at `/privacy-policy`
- [x] Terms of Service page accessible at `/terms-of-service`
- [x] Contact page accessible at `/contact`
- [x] All pages include footer links to policies
- [x] YouTube ToS reference present in footer
- [x] Data deletion instructions with Google security settings link
- [x] Cookie disclosure present
- [x] Contact information prominently displayed
- [x] YouTube branding violations fixed (no custom YouTube logos)
- [x] Google sign-in button follows branding guidelines
- [ ] OAuth consent screen updated with policy URLs (requires manual action in Google Cloud Console)

---

**All code-level violations have been resolved. The only remaining action is to update the OAuth consent screen in Google Cloud Console with the new policy URLs.**
