<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class CreateAdminUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:create';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create admin user for DAYBot';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $user = User::firstOrCreate(
            ['email' => 'admin@daybot.tv'],
            [
                'name' => 'Admin',
                'password' => Hash::make('Admin@1337123'),
                'is_admin' => true,
            ]
        );

        if ($user->wasRecentlyCreated) {
            $this->info('✅ Admin user created successfully!');
        } else {
            $this->info('✅ Admin user already exists.');
        }

        $this->line('');
        $this->line('Admin Login Credentials:');
        $this->line('Email: admin@daybot.tv');
        $this->line('Password: Admin@1337123');

        return 0;
    }
}
