<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserIsAuthorized
{
    /**
     * Handle an incoming request.
     * Only allow vanihbx@gmail.com to access the dashboard
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if (!$user || $user->email !== 'vanishbx@gmail.com') {
            abort(403, 'Unauthorized access. Only authorized users can access this area.');
        }

        return $next($request);
    }
}
