<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BannedKeyword extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'keyword',
        'timeout_duration',
        'is_enabled',
    ];

    protected function casts(): array
    {
        return [
            'is_enabled' => 'boolean',
        ];
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    /**
     * Check if text contains this banned keyword
     */
    public function matches(string $text): bool
    {
        if (!$this->is_enabled) {
            return false;
        }

        $lowerText = mb_strtolower($text);
        $lowerKeyword = mb_strtolower($this->keyword);

        return str_contains($lowerText, $lowerKeyword);
    }
}
