<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BotAccount extends Model
{
    protected $table = 'bot_account';

    protected $fillable = [
        'channel_id',
        'channel_title',
        'channel_handle',
        'access_token',
        'refresh_token',
        'expires_at',
        'scopes',
        'is_connected',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'scopes' => 'array',
        'is_connected' => 'boolean',
    ];

    /**
     * Check if token is expired
     */
    public function isExpired(): bool
    {
        return $this->expires_at->isPast();
    }

    /**
     * Check if token needs refresh (expires in 5 minutes)
     */
    public function needsRefresh(): bool
    {
        return $this->expires_at->subMinutes(5)->isPast();
    }

    /**
     * Get the connected bot account (singleton)
     */
    public static function getConnected(): ?self
    {
        return self::where('is_connected', true)->first();
    }
}
