<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Command extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'name',
        'response',
        'cooldown_sec',
        'required_role',
        'is_enabled',
        'aliases',
        'variables',
        'use_count',
        'last_used_at',
    ];

    protected function casts(): array
    {
        return [
            'is_enabled' => 'boolean',
            'aliases' => 'array',
            'variables' => 'array',
            'last_used_at' => 'datetime',
        ];
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function isOnCooldown(): bool
    {
        if (!$this->last_used_at) {
            return false;
        }

        return now()->diffInSeconds($this->last_used_at) < $this->cooldown_sec;
    }

    public function incrementUseCount(): void
    {
        $this->increment('use_count');
        $this->update(['last_used_at' => now()]);
    }

    public function getAllNames(): array
    {
        $names = [$this->name];
        if ($this->aliases) {
            $names = array_merge($names, $this->aliases);
        }
        return $names;
    }
}
