<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GiveawayEntry extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'giveaway_id',
        'user_channel_id',
        'user_name',
        'entered_at',
    ];

    protected function casts(): array
    {
        return [
            'entered_at' => 'datetime',
        ];
    }

    public function giveaway()
    {
        return $this->belongsTo(Giveaway::class);
    }
}
