<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'key',
        'value',
    ];

    protected function casts(): array
    {
        return [
            // No casting - keep value as string for flexibility
            // Supports both simple values ('0', '1') and complex values
        ];
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
