<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserWarning extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'user_channel_id',
        'user_name',
        'violation_type',
        'violation_details',
        'warning_count',
        'last_violation_at',
        'expires_at',
    ];

    protected function casts(): array
    {
        return [
            'last_violation_at' => 'datetime',
            'expires_at' => 'datetime',
        ];
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    /**
     * Check if warning is still active (not expired)
     */
    public function isActive(): bool
    {
        if (!$this->expires_at) {
            return true;
        }

        return now()->lt($this->expires_at);
    }

    /**
     * Increment warning count
     */
    public function incrementWarning(string $details = null): void
    {
        $this->update([
            'warning_count' => $this->warning_count + 1,
            'last_violation_at' => now(),
            'violation_details' => $details,
            'expires_at' => now()->addHours(24), // warnings expire after 24 hours
        ]);
    }
}
