<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

$tenant = App\Models\Tenant::find(16);

if (!$tenant) {
    echo "Tenant not found!\n";
    exit;
}

echo "=== Tenant 16 Settings ===\n\n";

$settings = $tenant->settings()->get();

foreach ($settings as $setting) {
    echo "{$setting->key} = '{$setting->value}'\n";
}

echo "\n=== Roasting Check ===\n";

$roastingValue = $tenant->settings()
    ->where('key', 'roasting_mode')
    ->value('value');

echo "Roasting value from DB: '{$roastingValue}'\n";
echo "Type: " . gettype($roastingValue) . "\n";
echo "Is '1'? " . ($roastingValue === '1' ? 'YES' : 'NO') . "\n";
echo "Is truthy? " . ($roastingValue ? 'YES' : 'NO') . "\n";

$roastingEnabled = $tenant->settings()
    ->where('key', 'roasting_mode')
    ->value('value') === '1';

echo "Roasting enabled (in code): " . ($roastingEnabled ? 'TRUE' : 'FALSE') . "\n";
