<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Google OAuth2 Configuration
    |--------------------------------------------------------------------------
    */

    'google' => [
        'client_id' => env('YT_CLIENT_ID'),
        'client_secret' => env('YT_CLIENT_SECRET'),
        'redirect' => env('YT_REDIRECT_URI'),
    ],

    /*
    |--------------------------------------------------------------------------
    | YouTube API Configuration
    |--------------------------------------------------------------------------
    */

    'youtube' => [
        'poll_interval_seconds' => env('YT_POLL_INTERVAL_SECONDS', 2),
        'poll_backoff_multiplier' => env('YT_POLL_BACKOFF_MULTIPLIER', 1.5),
        'poll_max_interval_seconds' => env('YT_POLL_MAX_INTERVAL_SECONDS', 30),
        'poll_max_results' => env('YT_POLL_MAX_RESULTS', 200),
    ],

    /*
    |--------------------------------------------------------------------------
    | OpenAI Configuration
    |--------------------------------------------------------------------------
    */

    'openai' => [
        'api_key' => env('OPENAI_API_KEY'),
        'model' => env('OPENAI_MODEL', 'gpt-4o-mini'),
        'temperature' => env('OPENAI_TEMPERATURE', 0.7),
        'max_tokens' => env('OPENAI_MAX_TOKENS', 200),
        'request_timeout' => env('OPENAI_REQUEST_TIMEOUT', 30),
        'enable_moderation' => env('ENABLE_CONTENT_MODERATION', true),
        'auto_detect_questions' => env('AUTO_DETECT_QUESTIONS', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Bot Behavior Configuration
    |--------------------------------------------------------------------------
    */

    'bot' => [
        'rate_limit_outbound_per_min' => env('RATE_LIMIT_OUTBOUND_PER_MIN', 200),
        'rate_limit_outbound_per_hour' => env('RATE_LIMIT_OUTBOUND_PER_HOUR', 2000),
        'user_cooldown' => env('RATE_LIMIT_USER_COOLDOWN', 10),
        'timer_activity_threshold' => env('TIMER_ACTIVITY_THRESHOLD', 3),
        'timer_activity_window_min' => env('TIMER_ACTIVITY_WINDOW_MIN', 10),
        'default_command_cooldown' => env('DEFAULT_COMMAND_COOLDOWN', 5),
    ],

];
