<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tenants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('channel_id')->unique();
            $table->string('channel_title');
            $table->string('channel_handle')->nullable();
            $table->string('live_chat_id')->nullable();
            $table->string('active_broadcast_id')->nullable();
            $table->enum('status', ['stopped', 'running', 'error'])->default('stopped');
            $table->string('last_seen_message_id')->nullable();
            $table->timestamp('last_polled_at')->nullable();
            $table->timestamp('broadcast_started_at')->nullable();
            $table->json('quotas')->nullable(); // quota tracking
            $table->json('settings')->nullable(); // tenant-specific settings
            $table->text('last_error')->nullable();
            $table->timestamp('last_error_at')->nullable();
            $table->timestamps();

            $table->index('user_id');
            $table->index('channel_id');
            $table->index('status');
            $table->index('live_chat_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tenants');
    }
};
