<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Change column type from JSON to TEXT using raw SQL
        // This bypasses the constraint temporarily
        DB::statement('ALTER TABLE settings MODIFY COLUMN value TEXT');

        // Now decode any JSON-encoded values to plain strings
        $settings = DB::table('settings')->get();
        foreach ($settings as $setting) {
            $value = $setting->value;

            // Try to decode if it's JSON
            $decoded = json_decode($value, true);
            if ($decoded !== null && $decoded !== $value) {
                // Was JSON-encoded, decode it
                $plainValue = is_string($decoded) ? $decoded : json_encode($decoded);
                DB::table('settings')->where('id', $setting->id)->update(['value' => $plainValue]);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->json('value')->change();
        });
    }
};
