<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->string('stream_type')->nullable()->after('status'); // gaming, tech, music, cooking, etc.
            $table->string('current_game')->nullable()->after('stream_type'); // e.g., "GTA V", "Valorant"
            $table->text('stream_description')->nullable()->after('current_game'); // Brief context about stream
            $table->timestamp('stream_context_updated_at')->nullable()->after('stream_description');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->dropColumn(['stream_type', 'current_game', 'stream_description', 'stream_context_updated_at']);
        });
    }
};
