<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_warnings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->string('user_channel_id');
            $table->string('user_name');
            $table->string('violation_type'); // 'banned_keyword', 'spam'
            $table->text('violation_details')->nullable();
            $table->integer('warning_count')->default(1);
            $table->timestamp('last_violation_at');
            $table->timestamp('expires_at')->nullable(); // warnings expire after 24 hours
            $table->timestamps();

            $table->index(['tenant_id', 'user_channel_id', 'violation_type']);
            $table->index(['tenant_id', 'expires_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_warnings');
    }
};
