<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->boolean('spam_protection_enabled')->default(false);
            $table->integer('spam_message_limit')->default(3); // how many same messages
            $table->integer('spam_time_window')->default(30); // in seconds
            $table->integer('spam_timeout_duration')->default(300); // timeout duration in seconds
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tenants', function (Blueprint $table) {
            $table->dropColumn(['spam_protection_enabled', 'spam_message_limit', 'spam_time_window', 'spam_timeout_duration']);
        });
    }
};
