<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Tenant;
use App\Services\StreamContextService;

$tenantId = $argv[1] ?? 16;

echo "=== Stream Context Detection ===\n\n";

$tenant = Tenant::find($tenantId);

if (!$tenant) {
    echo "❌ Tenant #{$tenantId} not found!\n";
    exit(1);
}

echo "Tenant: {$tenant->channel_title}\n";
echo "Channel ID: {$tenant->channel_id}\n\n";

echo "Detecting stream context...\n";

$service = new StreamContextService();
$result = $service->detectAndUpdateContext($tenant);

if ($result) {
    // Refresh tenant to get updated values
    $tenant->refresh();

    echo "\n✅ Stream context detected successfully!\n\n";
    echo "Stream Type: " . ($tenant->stream_type ? $tenant->stream_type : 'N/A') . "\n";
    echo "Current Game: " . ($tenant->current_game ? $tenant->current_game : 'N/A') . "\n";
    echo "Description: " . ($tenant->stream_description ? $tenant->stream_description : 'N/A') . "\n";
    echo "Updated At: " . ($tenant->stream_context_updated_at ? $tenant->stream_context_updated_at->format('Y-m-d H:i:s') : 'N/A') . "\n";

    echo "\n📺 Bot will now use this context in replies!\n";
} else {
    echo "\n❌ Failed to detect stream context.\n";
    echo "Check logs for details: storage/logs/laravel.log\n";
    exit(1);
}
