<?php
/**
 * Fix Roasting Mode Settings - Convert any non-string values to proper strings
 */

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "=== Fixing Roasting Mode Settings ===\n\n";

// Get all settings
$settings = \App\Models\Setting::all();

foreach ($settings as $setting) {
    $oldValue = $setting->getRawOriginal('value');
    echo "Tenant {$setting->tenant_id} - {$setting->key}:\n";
    echo "  Old value: " . var_export($oldValue, true) . " (type: " . gettype($oldValue) . ")\n";

    // If value is null or not a simple string, fix it
    if ($setting->key === 'roasting_mode') {
        // Roasting mode should be '0' or '1'
        // Handle JSON-encoded values from old array cast
        $decodedValue = is_string($oldValue) ? json_decode($oldValue) : $oldValue;

        if ($decodedValue === null || $decodedValue === '' || $decodedValue === 'null') {
            $newValue = '0'; // Default to OFF
        } elseif (is_array($decodedValue) || is_object($decodedValue)) {
            // If it's an array/object (due to old cast), default to OFF
            $newValue = '0';
        } else {
            // Keep existing value if it's valid
            $newValue = ($decodedValue === '1' || $decodedValue === 1 || $decodedValue === true) ? '1' : '0';
        }

        if ($newValue !== $oldValue) {
            \DB::table('settings')
                ->where('id', $setting->id)
                ->update(['value' => $newValue]);
            echo "  ✅ Fixed to: '{$newValue}'\n";
        } else {
            echo "  ℹ️  Already correct: '{$newValue}'\n";
        }
    } else {
        // For other settings, just ensure they're strings (decode JSON if needed)
        $decodedValue = is_string($oldValue) ? json_decode($oldValue) : $oldValue;

        if ($decodedValue !== $oldValue) {
            // Was JSON-encoded, save as plain string
            $newValue = is_string($decodedValue) ? $decodedValue : (string)$decodedValue;
            \DB::table('settings')
                ->where('id', $setting->id)
                ->update(['value' => $newValue]);
            echo "  ✅ Decoded from JSON: '{$newValue}'\n";
        } elseif (!is_string($oldValue)) {
            $newValue = (string)$oldValue;
            \DB::table('settings')
                ->where('id', $setting->id)
                ->update(['value' => $newValue]);
            echo "  ✅ Converted to string: '{$newValue}'\n";
        } else {
            echo "  ℹ️  Already correct\n";
        }
    }
    echo "\n";
}

echo "=== Done! ===\n";
echo "\nYou can now test the roasting toggle in the dashboard.\n";
