'use client';

import React from 'react';
import Layout from '@/components/layout/Layout';
import Button from '@/components/ui/Button';
import Card from '@/components/ui/Card';
import Badge from '@/components/ui/Badge';

const mockUser = {
  name: 'Gaming Channel',
  email: 'user@example.com',
};

const mockInvoices = [
  { id: 1, date: '2025-01-01', amount: '$19.99', status: 'paid', plan: 'Pro' },
  { id: 2, date: '2024-12-01', amount: '$19.99', status: 'paid', plan: 'Pro' },
  { id: 3, date: '2024-11-01', amount: '$19.99', status: 'paid', plan: 'Pro' },
];

export default function Billing() {
  return (
    <Layout user={mockUser}>
      {/* Page Header */}
      <div className="mb-8">
        <h1 className="text-title text-text-primary mb-2">Billing & Plans</h1>
        <p className="text-text-secondary">
          Manage your subscription and billing information
        </p>
      </div>

      {/* Current Plan */}
      <Card
        title="Current Plan"
        subtitle="You're currently on the Pro plan"
        className="mb-8"
      >
        <div className="flex flex-col md:flex-row md:items-center md:justify-between gap-6">
          <div>
            <div className="flex items-center space-x-3 mb-2">
              <h3 className="text-2xl font-bold text-text-primary">Pro Plan</h3>
              <Badge variant="primary">Active</Badge>
            </div>
            <p className="text-text-secondary mb-4">
              Unlimited channels, AI responses, and priority support
            </p>
            <div className="flex items-baseline space-x-2">
              <span className="text-3xl font-bold text-text-primary">$19.99</span>
              <span className="text-text-muted">/month</span>
            </div>
            <p className="text-sm text-text-muted mt-2">
              Next billing date: <span className="text-text-primary font-medium">February 1, 2025</span>
            </p>
          </div>

          <div className="flex flex-col gap-3">
            <Button variant="primary">Manage Subscription</Button>
            <Button variant="secondary">Cancel Plan</Button>
          </div>
        </div>
      </Card>

      {/* Available Plans */}
      <div className="mb-8">
        <h2 className="text-xl font-semibold text-text-primary mb-4">Available Plans</h2>
        <div className="grid md:grid-cols-3 gap-6">
          {/* Free Plan */}
          <Card padding="default" hover className="relative">
            <div className="mb-6">
              <h3 className="text-xl font-semibold text-text-primary mb-2">Free</h3>
              <div className="flex items-baseline space-x-2 mb-4">
                <span className="text-3xl font-bold text-text-primary">$0</span>
                <span className="text-text-muted">/month</span>
              </div>
              <p className="text-sm text-text-secondary">Perfect for getting started</p>
            </div>

            <ul className="space-y-3 mb-6">
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">1 YouTube channel</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Basic AI responses</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">5 custom commands</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-text-muted flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M6 18L18 6M6 6l12 12" />
                </svg>
                <span className="text-sm text-text-muted">No roasting mode</span>
              </li>
            </ul>

            <Button variant="secondary" fullWidth disabled>
              Current Plan
            </Button>
          </Card>

          {/* Pro Plan */}
          <Card padding="default" hover className="relative border-primary/50 shadow-button">
            <Badge variant="primary" className="absolute -top-3 left-1/2 -translate-x-1/2">
              Popular
            </Badge>

            <div className="mb-6 mt-2">
              <h3 className="text-xl font-semibold text-text-primary mb-2">Pro</h3>
              <div className="flex items-baseline space-x-2 mb-4">
                <span className="text-3xl font-bold text-text-primary">$19.99</span>
                <span className="text-text-muted">/month</span>
              </div>
              <p className="text-sm text-text-secondary">For serious streamers</p>
            </div>

            <ul className="space-y-3 mb-6">
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Unlimited channels</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Advanced AI responses</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Unlimited commands</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Roasting mode (all levels)</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Priority support</span>
              </li>
            </ul>

            <Button variant="primary" fullWidth>
              Current Plan
            </Button>
          </Card>

          {/* Enterprise Plan */}
          <Card padding="default" hover className="relative">
            <div className="mb-6">
              <h3 className="text-xl font-semibold text-text-primary mb-2">Enterprise</h3>
              <div className="flex items-baseline space-x-2 mb-4">
                <span className="text-3xl font-bold text-text-primary">Custom</span>
              </div>
              <p className="text-sm text-text-secondary">For large organizations</p>
            </div>

            <ul className="space-y-3 mb-6">
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Everything in Pro</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Custom integrations</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">Dedicated support</span>
              </li>
              <li className="flex items-start space-x-3">
                <svg className="w-5 h-5 text-success flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                </svg>
                <span className="text-sm text-text-secondary">SLA guarantee</span>
              </li>
            </ul>

            <Button variant="secondary" fullWidth>
              Contact Sales
            </Button>
          </Card>
        </div>
      </div>

      {/* Billing History */}
      <Card title="Billing History" subtitle="Your past invoices and payments">
        <div className="overflow-x-auto custom-scrollbar">
          <table className="w-full">
            <thead>
              <tr className="border-b border-border">
                <th className="text-left px-4 py-3 text-label text-text-muted uppercase">Date</th>
                <th className="text-left px-4 py-3 text-label text-text-muted uppercase">Plan</th>
                <th className="text-left px-4 py-3 text-label text-text-muted uppercase">Amount</th>
                <th className="text-left px-4 py-3 text-label text-text-muted uppercase">Status</th>
                <th className="text-right px-4 py-3 text-label text-text-muted uppercase">Invoice</th>
              </tr>
            </thead>
            <tbody>
              {mockInvoices.map((invoice, index) => (
                <tr
                  key={invoice.id}
                  className={`hover:bg-hover transition-colors ${
                    index !== mockInvoices.length - 1 ? 'border-b border-border' : ''
                  }`}
                >
                  <td className="px-4 py-4 text-sm text-text-primary">{invoice.date}</td>
                  <td className="px-4 py-4 text-sm text-text-secondary">{invoice.plan}</td>
                  <td className="px-4 py-4 text-sm font-medium text-text-primary">{invoice.amount}</td>
                  <td className="px-4 py-4">
                    <Badge variant="success" size="sm">
                      {invoice.status}
                    </Badge>
                  </td>
                  <td className="px-4 py-4 text-right">
                    <Button variant="ghost" size="sm">
                      <svg className="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                      </svg>
                      <span className="ml-1">Download</span>
                    </Button>
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      </Card>
    </Layout>
  );
}
