import React from 'react';
import Link from 'next/link';
import Layout from '@/components/layout/Layout';
import Button from '@/components/ui/Button';

export default function NotFound() {
  return (
    <Layout maxWidth="narrow">
      <div className="min-h-[calc(100vh-300px)] flex items-center justify-center py-12">
        <div className="text-center">
          {/* Animated 404 Illustration */}
          <div className="relative mb-8">
            <div className="absolute inset-0 flex items-center justify-center">
              <div className="w-64 h-64 bg-primary/10 rounded-full blur-3xl animate-pulse"></div>
            </div>
            <div className="relative">
              <h1 className="text-9xl font-bold gradient-text mb-4">404</h1>
              <div className="flex justify-center space-x-2">
                <div className="w-3 h-3 bg-primary rounded-full animate-bounce"></div>
                <div className="w-3 h-3 bg-secondary rounded-full animate-bounce animation-delay-200"></div>
                <div className="w-3 h-3 bg-primary rounded-full animate-bounce animation-delay-400"></div>
              </div>
            </div>
          </div>

          {/* Error Message */}
          <h2 className="text-3xl font-bold text-text-primary mb-4">
            Page Not Found
          </h2>
          <p className="text-lg text-text-secondary mb-8 max-w-md mx-auto">
            Sorry, we couldn't find the page you're looking for. The page might have been moved or deleted.
          </p>

          {/* Action Buttons */}
          <div className="flex flex-col sm:flex-row items-center justify-center gap-4">
            <Link href="/dashboard">
              <Button variant="primary" size="lg">
                <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                </svg>
                <span className="ml-2">Go to Dashboard</span>
              </Button>
            </Link>
            <Link href="/">
              <Button variant="secondary" size="lg">
                Back to Home
              </Button>
            </Link>
          </div>

          {/* Help Links */}
          <div className="mt-12 pt-8 border-t border-border">
            <p className="text-sm text-text-muted mb-4">Need help? Try these:</p>
            <div className="flex flex-wrap items-center justify-center gap-6">
              <Link href="/commands" className="text-sm text-primary hover:text-primary-light transition-colors">
                Commands
              </Link>
              <Link href="/settings" className="text-sm text-primary hover:text-primary-light transition-colors">
                Settings
              </Link>
              <Link href="/billing" className="text-sm text-primary hover:text-primary-light transition-colors">
                Billing
              </Link>
              <a href="mailto:support@pxebot.com" className="text-sm text-primary hover:text-primary-light transition-colors">
                Contact Support
              </a>
            </div>
          </div>
        </div>
      </div>
    </Layout>
  );
}
