import React from 'react';
import Link from 'next/link';
import Layout from '@/components/layout/Layout';
import Button from '@/components/ui/Button';
import Card from '@/components/ui/Card';
import Badge from '@/components/ui/Badge';

export default function Home() {
  return (
    <Layout maxWidth="full">
      {/* Hero Section */}
      <section className="relative overflow-hidden">
        {/* Animated Background */}
        <div className="absolute inset-0 overflow-hidden">
          <div className="absolute -top-40 -right-40 w-80 h-80 bg-primary/20 rounded-full blur-3xl animate-float"></div>
          <div className="absolute -bottom-40 -left-40 w-80 h-80 bg-secondary/20 rounded-full blur-3xl animate-float animation-delay-400"></div>
        </div>

        <div className="relative max-w-container mx-auto px-6 lg:px-8 py-24 lg:py-32">
          <div className="text-center max-w-4xl mx-auto">
            {/* Badge */}
            <div className="flex justify-center mb-8">
              <Badge variant="primary" size="md">
                🚀 AI-Powered YouTube Chat Bot
              </Badge>
            </div>

            {/* Heading */}
            <h1 className="text-5xl lg:text-6xl font-bold text-text-primary mb-6">
              Supercharge Your YouTube
              <br />
              <span className="gradient-text">Live Streams with AI</span>
            </h1>

            {/* Description */}
            <p className="text-xl text-text-secondary mb-10 max-w-2xl mx-auto">
              PXEBot is an intelligent chatbot that engages your audience, moderates chat,
              and provides real-time responses in any language — making your streams more interactive than ever.
            </p>

            {/* CTA Buttons */}
            <div className="flex flex-col sm:flex-row items-center justify-center gap-4 mb-16">
              <Link href="/register">
                <Button variant="primary" size="lg" className="min-w-[200px]">
                  <svg className="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                  </svg>
                  <span className="ml-2">Connect Your Channel</span>
                </Button>
              </Link>
              <Link href="/demo">
                <Button variant="secondary" size="lg" className="min-w-[200px]">
                  Watch Demo
                </Button>
              </Link>
            </div>

            {/* Stats */}
            <div className="grid grid-cols-3 gap-8 max-w-2xl mx-auto">
              <div>
                <div className="text-3xl font-bold text-text-primary mb-2">10K+</div>
                <div className="text-sm text-text-secondary">Messages Handled</div>
              </div>
              <div>
                <div className="text-3xl font-bold text-text-primary mb-2">500+</div>
                <div className="text-sm text-text-secondary">Active Channels</div>
              </div>
              <div>
                <div className="text-3xl font-bold text-text-primary mb-2">99.9%</div>
                <div className="text-sm text-text-secondary">Uptime</div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="max-w-container mx-auto px-6 lg:px-8 py-24">
        <div className="text-center mb-16">
          <Badge variant="primary" className="mb-4">Features</Badge>
          <h2 className="text-4xl font-bold text-text-primary mb-4">
            Everything You Need for Live Chat
          </h2>
          <p className="text-lg text-text-secondary max-w-2xl mx-auto">
            Powerful AI capabilities designed specifically for YouTube streamers
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          <Card hover padding="default">
            <div className="w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center text-primary mb-4">
              <svg className="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
              </svg>
            </div>
            <h3 className="text-xl font-semibold text-text-primary mb-2">AI Chat Responses</h3>
            <p className="text-text-secondary">
              Intelligent responses powered by OpenAI that understand context and engage naturally with your viewers.
            </p>
          </Card>

          <Card hover padding="default">
            <div className="w-12 h-12 rounded-xl bg-secondary/10 flex items-center justify-center text-secondary mb-4">
              <svg className="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129" />
              </svg>
            </div>
            <h3 className="text-xl font-semibold text-text-primary mb-2">Multi-Language Support</h3>
            <p className="text-text-secondary">
              Automatically detects and responds in Urdu, English, Hindi, Arabic, and more — even Roman script.
            </p>
          </Card>

          <Card hover padding="default">
            <div className="w-12 h-12 rounded-xl bg-success/10 flex items-center justify-center text-success mb-4">
              <svg className="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
              </svg>
            </div>
            <h3 className="text-xl font-semibold text-text-primary mb-2">Content Moderation</h3>
            <p className="text-text-secondary">
              Built-in AI moderation keeps your chat safe by filtering inappropriate content automatically.
            </p>
          </Card>

          <Card hover padding="default">
            <div className="w-12 h-12 rounded-xl bg-warning/10 flex items-center justify-center text-warning mb-4">
              <svg className="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
              </svg>
            </div>
            <h3 className="text-xl font-semibold text-text-primary mb-2">Custom Commands & Timers</h3>
            <p className="text-text-secondary">
              Create custom commands and automated messages to keep your chat engaged and informed.
            </p>
          </Card>

          <Card hover padding="default">
            <div className="w-12 h-12 rounded-xl bg-danger/10 flex items-center justify-center text-danger mb-4">
              <svg className="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17.657 18.657A8 8 0 016.343 7.343S7 9 9 10c0-2 .5-5 2.986-7C14 5 16.09 5.777 17.656 7.343A7.975 7.975 0 0120 13a7.975 7.975 0 01-2.343 5.657z" />
              </svg>
            </div>
            <h3 className="text-xl font-semibold text-text-primary mb-2">Roasting Mode</h3>
            <p className="text-text-secondary">
              Let your bot have personality! Enable roasting mode with customizable levels from playful to savage.
            </p>
          </Card>

          <Card hover padding="default">
            <div className="w-12 h-12 rounded-xl bg-primary/10 flex items-center justify-center text-primary mb-4">
              <svg className="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
              </svg>
            </div>
            <h3 className="text-xl font-semibold text-text-primary mb-2">Real-Time Analytics</h3>
            <p className="text-text-secondary">
              Track message rates, viewer engagement, and bot performance with live dashboard metrics.
            </p>
          </Card>
        </div>
      </section>

      {/* CTA Section */}
      <section className="max-w-container mx-auto px-6 lg:px-8 py-24">
        <Card padding="lg" className="text-center bg-gradient-to-br from-primary/10 to-secondary/10 border-primary/20">
          <h2 className="text-4xl font-bold text-text-primary mb-4">
            Ready to Transform Your Live Streams?
          </h2>
          <p className="text-lg text-text-secondary mb-8 max-w-2xl mx-auto">
            Join hundreds of streamers using PXEBot to create more engaging, interactive experiences for their audience.
          </p>
          <Link href="/register">
            <Button variant="primary" size="lg" className="min-w-[250px]">
              Get Started — It's Free
            </Button>
          </Link>
        </Card>
      </section>
    </Layout>
  );
}
