'use client';

import React, { useState } from 'react';
import Layout from '@/components/layout/Layout';
import Button from '@/components/ui/Button';
import Card from '@/components/ui/Card';
import Input from '@/components/ui/Input';
import Toggle from '@/components/ui/Toggle';
import Badge from '@/components/ui/Badge';

const mockUser = {
  name: 'Gaming Channel',
  email: 'user@example.com',
};

export default function Settings() {
  const [formData, setFormData] = useState({
    channelName: 'Gaming Pro Channel',
    email: 'user@example.com',
    currentPassword: '',
    newPassword: '',
    confirmPassword: '',
  });

  const [notifications, setNotifications] = useState({
    botStatus: true,
    errorAlerts: true,
    weeklyReports: false,
    newFeatures: true,
  });

  const [loading, setLoading] = useState(false);

  const handleSaveProfile = async () => {
    setLoading(true);
    setTimeout(() => setLoading(false), 1000);
  };

  const handleChangePassword = async () => {
    setLoading(true);
    setTimeout(() => setLoading(false), 1000);
  };

  return (
    <Layout user={mockUser}>
      {/* Page Header */}
      <div className="mb-8">
        <h1 className="text-title text-text-primary mb-2">Settings</h1>
        <p className="text-text-secondary">
          Manage your account preferences and security settings
        </p>
      </div>

      <div className="grid lg:grid-cols-3 gap-6">
        {/* Sidebar Navigation */}
        <div className="lg:col-span-1">
          <Card padding="none" className="sticky top-24">
            <nav className="p-2">
              <button className="w-full flex items-center space-x-3 px-4 py-3 rounded-lg bg-primary/10 text-primary">
                <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                </svg>
                <span className="font-medium">Profile</span>
              </button>
              <button className="w-full flex items-center space-x-3 px-4 py-3 rounded-lg text-text-secondary hover:bg-hover hover:text-text-primary transition-all duration-200">
                <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                </svg>
                <span className="font-medium">Security</span>
              </button>
              <button className="w-full flex items-center space-x-3 px-4 py-3 rounded-lg text-text-secondary hover:bg-hover hover:text-primary transition-all duration-200">
                <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                </svg>
                <span className="font-medium">Notifications</span>
              </button>
              <button className="w-full flex items-center space-x-3 px-4 py-3 rounded-lg text-text-secondary hover:bg-hover hover:text-text-primary transition-all duration-200">
                <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                <span className="font-medium">Integrations</span>
              </button>
            </nav>
          </Card>
        </div>

        {/* Main Content */}
        <div className="lg:col-span-2 space-y-6">
          {/* Profile Section */}
          <Card
            title="Profile Information"
            subtitle="Update your account details and channel information"
          >
            <div className="space-y-6">
              <div className="flex items-center space-x-4">
                <div className="w-20 h-20 rounded-xl bg-gradient-to-br from-primary to-secondary flex items-center justify-center text-white text-2xl font-bold">
                  GP
                </div>
                <div>
                  <Button variant="secondary" size="sm">Upload Avatar</Button>
                  <p className="text-xs text-text-muted mt-2">JPG, PNG or GIF. Max 2MB.</p>
                </div>
              </div>

              <Input
                label="Channel Name"
                value={formData.channelName}
                onChange={(e) => setFormData({ ...formData, channelName: e.target.value })}
                placeholder="Your channel name"
              />

              <Input
                label="Email Address"
                type="email"
                value={formData.email}
                onChange={(e) => setFormData({ ...formData, email: e.target.value })}
                placeholder="you@example.com"
              />

              <div className="flex justify-end">
                <Button variant="primary" onClick={handleSaveProfile} loading={loading}>
                  Save Changes
                </Button>
              </div>
            </div>
          </Card>

          {/* Security Section */}
          <Card
            title="Change Password"
            subtitle="Update your password to keep your account secure"
          >
            <div className="space-y-6">
              <Input
                label="Current Password"
                type="password"
                value={formData.currentPassword}
                onChange={(e) => setFormData({ ...formData, currentPassword: e.target.value })}
                placeholder="Enter current password"
              />

              <Input
                label="New Password"
                type="password"
                value={formData.newPassword}
                onChange={(e) => setFormData({ ...formData, newPassword: e.target.value })}
                placeholder="Enter new password"
                hint="At least 8 characters with letters and numbers"
              />

              <Input
                label="Confirm New Password"
                type="password"
                value={formData.confirmPassword}
                onChange={(e) => setFormData({ ...formData, confirmPassword: e.target.value })}
                placeholder="Confirm new password"
              />

              <div className="flex justify-end">
                <Button variant="primary" onClick={handleChangePassword} loading={loading}>
                  Update Password
                </Button>
              </div>
            </div>
          </Card>

          {/* Notifications Section */}
          <Card
            title="Notification Preferences"
            subtitle="Manage how you receive updates and alerts"
          >
            <div className="space-y-6">
              <Toggle
                label="Bot Status Changes"
                description="Get notified when your bot starts or stops"
                checked={notifications.botStatus}
                onChange={(checked) => setNotifications({ ...notifications, botStatus: checked })}
              />

              <Toggle
                label="Error Alerts"
                description="Receive immediate alerts for critical errors"
                checked={notifications.errorAlerts}
                onChange={(checked) => setNotifications({ ...notifications, errorAlerts: checked })}
              />

              <Toggle
                label="Weekly Reports"
                description="Get weekly summary of bot activity and stats"
                checked={notifications.weeklyReports}
                onChange={(checked) => setNotifications({ ...notifications, weeklyReports: checked })}
              />

              <Toggle
                label="New Features"
                description="Stay updated about new features and improvements"
                checked={notifications.newFeatures}
                onChange={(checked) => setNotifications({ ...notifications, newFeatures: checked })}
              />
            </div>
          </Card>

          {/* Danger Zone */}
          <Card
            title="Danger Zone"
            subtitle="Irreversible actions for your account"
            className="border-danger/50"
          >
            <div className="space-y-4">
              <div className="flex items-start justify-between p-4 border border-border rounded-xl">
                <div>
                  <h4 className="text-sm font-medium text-text-primary mb-1">Delete Account</h4>
                  <p className="text-sm text-text-secondary">
                    Permanently delete your account and all associated data
                  </p>
                </div>
                <Button variant="danger" size="sm">
                  Delete
                </Button>
              </div>

              <div className="flex items-start justify-between p-4 border border-border rounded-xl">
                <div>
                  <h4 className="text-sm font-medium text-text-primary mb-1">Disconnect YouTube</h4>
                  <p className="text-sm text-text-secondary">
                    Remove all connected YouTube channels
                  </p>
                </div>
                <Button variant="danger" size="sm">
                  Disconnect
                </Button>
              </div>
            </div>
          </Card>
        </div>
      </div>
    </Layout>
  );
}
