import React, { useState } from 'react';
import Link from 'next/link';
import Button from '../ui/Button';

const Header = ({ user = null }) => {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);
  const [userMenuOpen, setUserMenuOpen] = useState(false);

  return (
    <header className="sticky top-0 z-50 bg-surface/95 backdrop-blur-xl border-b border-border">
      <div className="max-w-container mx-auto px-6 lg:px-8">
        <div className="flex items-center justify-between h-16">
          {/* Logo */}
          <Link href="/" className="flex items-center space-x-3 group">
            <div className="w-10 h-10 rounded-xl bg-gradient-to-br from-primary to-secondary flex items-center justify-center shadow-button group-hover:shadow-glow transition-all duration-200">
              <svg className="w-6 h-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
              </svg>
            </div>
            <span className="text-xl font-semibold text-text-primary">PXEBot</span>
          </Link>

          {/* Desktop Navigation */}
          {user && (
            <nav className="hidden md:flex items-center space-x-1">
              <Link href="/dashboard" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Dashboard
              </Link>
              <Link href="/commands" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Commands
              </Link>
              <Link href="/timers" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Timers
              </Link>
              <Link href="/settings" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Settings
              </Link>
            </nav>
          )}

          {/* Right Side */}
          <div className="flex items-center space-x-4">
            {user ? (
              <>
                <Button variant="primary" size="sm" className="hidden sm:inline-flex">
                  <svg className="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 4v16m8-8H4" />
                  </svg>
                  <span className="ml-2">Add Channel</span>
                </Button>

                {/* User Menu */}
                <div className="relative">
                  <button
                    onClick={() => setUserMenuOpen(!userMenuOpen)}
                    className="flex items-center space-x-3 hover:bg-hover rounded-lg px-3 py-2 transition-all duration-200"
                  >
                    <div className="w-8 h-8 rounded-lg bg-gradient-to-br from-primary to-secondary flex items-center justify-center text-white text-sm font-semibold">
                      {user.name?.[0]?.toUpperCase() || 'U'}
                    </div>
                    <div className="hidden md:block text-left">
                      <p className="text-sm font-medium text-text-primary">{user.name}</p>
                      <p className="text-xs text-text-muted">{user.email}</p>
                    </div>
                  </button>

                  {/* Dropdown */}
                  {userMenuOpen && (
                    <div className="absolute right-0 mt-2 w-56 bg-surface border border-border rounded-xl shadow-premium overflow-hidden">
                      <div className="p-3 border-b border-border">
                        <p className="text-sm font-medium text-text-primary">{user.name}</p>
                        <p className="text-xs text-text-muted">{user.email}</p>
                      </div>
                      <div className="py-2">
                        <Link href="/profile" className="block px-4 py-2 text-sm text-text-secondary hover:bg-hover hover:text-text-primary transition-colors">
                          Profile Settings
                        </Link>
                        <Link href="/billing" className="block px-4 py-2 text-sm text-text-secondary hover:bg-hover hover:text-text-primary transition-colors">
                          Billing
                        </Link>
                        <button className="w-full text-left px-4 py-2 text-sm text-danger hover:bg-danger/10 transition-colors">
                          Sign Out
                        </button>
                      </div>
                    </div>
                  )}
                </div>
              </>
            ) : (
              <>
                <Link href="/login">
                  <Button variant="ghost" size="sm">Sign In</Button>
                </Link>
                <Link href="/register">
                  <Button variant="primary" size="sm">Get Started</Button>
                </Link>
              </>
            )}

            {/* Mobile Menu Button */}
            <button
              onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
              className="md:hidden p-2 text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200"
            >
              <svg className="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 6h16M4 12h16M4 18h16" />
              </svg>
            </button>
          </div>
        </div>

        {/* Mobile Menu */}
        {mobileMenuOpen && user && (
          <div className="md:hidden py-4 border-t border-border">
            <nav className="flex flex-col space-y-1">
              <Link href="/dashboard" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Dashboard
              </Link>
              <Link href="/commands" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Commands
              </Link>
              <Link href="/timers" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Timers
              </Link>
              <Link href="/settings" className="px-4 py-2 text-sm font-medium text-text-secondary hover:text-text-primary hover:bg-hover rounded-lg transition-all duration-200">
                Settings
              </Link>
            </nav>
          </div>
        )}
      </div>
    </header>
  );
};

export default Header;
