import React from 'react';
import Header from './Header';

const Layout = ({ children, user = null, maxWidth = 'container' }) => {
  const maxWidths = {
    container: 'max-w-container',
    full: 'max-w-full',
    narrow: 'max-w-4xl',
  };

  return (
    <div className="min-h-screen bg-background">
      <Header user={user} />
      <main className={`${maxWidths[maxWidth]} mx-auto px-6 lg:px-8 py-8`}>
        {children}
      </main>
    </div>
  );
};

export default Layout;
