import React from 'react';

const Card = ({
  children,
  title,
  subtitle,
  icon,
  action,
  hover = false,
  className = '',
  padding = 'default',
  ...props
}) => {
  const baseStyles = 'bg-surface border border-border rounded-xl transition-all duration-200';
  const hoverStyles = hover ? 'hover:border-primary/50 hover:shadow-card cursor-pointer' : '';

  const paddings = {
    none: '',
    sm: 'p-4',
    default: 'p-6',
    lg: 'p-8',
  };

  return (
    <div className={`${baseStyles} ${hoverStyles} ${paddings[padding]} ${className}`} {...props}>
      {(title || subtitle || action) && (
        <div className="flex items-start justify-between mb-6">
          <div className="flex items-start space-x-3">
            {icon && (
              <div className="flex-shrink-0 w-10 h-10 rounded-lg bg-primary/10 flex items-center justify-center text-primary">
                {icon}
              </div>
            )}
            <div>
              {title && <h3 className="text-lg font-semibold text-text-primary">{title}</h3>}
              {subtitle && <p className="text-sm text-text-secondary mt-1">{subtitle}</p>}
            </div>
          </div>
          {action && <div className="flex-shrink-0">{action}</div>}
        </div>
      )}
      {children}
    </div>
  );
};

export default Card;
