import React from 'react';

const Input = ({
  label,
  error,
  hint,
  icon,
  type = 'text',
  fullWidth = true,
  className = '',
  ...props
}) => {
  const baseStyles = 'h-11 px-4 bg-surface border border-border rounded-xl text-text-primary placeholder:text-text-muted focus:outline-none focus:ring-2 focus:ring-primary/50 focus:border-primary transition-all duration-200';
  const errorStyles = error ? 'border-danger focus:ring-danger/50 focus:border-danger' : '';
  const widthClass = fullWidth ? 'w-full' : '';

  return (
    <div className={fullWidth ? 'w-full' : ''}>
      {label && (
        <label className="block text-sm font-medium text-text-primary mb-2">
          {label}
        </label>
      )}
      <div className="relative">
        {icon && (
          <div className="absolute left-4 top-1/2 -translate-y-1/2 text-text-muted">
            {icon}
          </div>
        )}
        <input
          type={type}
          className={`${baseStyles} ${errorStyles} ${widthClass} ${icon ? 'pl-12' : ''} ${className}`}
          {...props}
        />
      </div>
      {error && (
        <p className="mt-2 text-sm text-danger">{error}</p>
      )}
      {hint && !error && (
        <p className="mt-2 text-sm text-text-muted">{hint}</p>
      )}
    </div>
  );
};

export default Input;
