import React from 'react';

const StatCard = ({
  label,
  value,
  subtitle,
  icon,
  trend,
  trendValue,
  color = 'primary',
  className = '',
}) => {
  const colors = {
    primary: 'text-primary bg-primary/10 border-primary/20',
    secondary: 'text-secondary bg-secondary/10 border-secondary/20',
    success: 'text-success bg-success/10 border-success/20',
    warning: 'text-warning bg-warning/10 border-warning/20',
    danger: 'text-danger bg-danger/10 border-danger/20',
  };

  return (
    <div className={`bg-surface border border-border rounded-xl p-6 hover:border-${color}/50 hover:shadow-card transition-all duration-200 ${className}`}>
      <div className="flex items-start justify-between mb-4">
        <div>
          <p className="text-label uppercase text-text-muted">{label}</p>
        </div>
        {icon && (
          <div className={`w-10 h-10 rounded-lg ${colors[color]} flex items-center justify-center border`}>
            {icon}
          </div>
        )}
      </div>

      <div className="space-y-2">
        <div className="text-3xl font-bold text-text-primary">
          {value}
        </div>

        {(subtitle || trendValue) && (
          <div className="flex items-center space-x-2">
            {trendValue && (
              <span className={`text-sm font-medium ${trend === 'up' ? 'text-success' : trend === 'down' ? 'text-danger' : 'text-text-muted'}`}>
                {trend === 'up' ? '↑' : trend === 'down' ? '↓' : '•'} {trendValue}
              </span>
            )}
            {subtitle && (
              <span className="text-sm text-text-secondary">{subtitle}</span>
            )}
          </div>
        )}
      </div>
    </div>
  );
};

export default StatCard;
