/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './pages/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
    './app/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      colors: {
        // PXEBot Design System - Professional Dark Theme
        background: '#0B0F19',
        surface: '#111827',
        border: '#1E293B',
        primary: {
          DEFAULT: '#3B82F6',
          light: '#60A5FA',
          dark: '#2563EB',
        },
        secondary: {
          DEFAULT: '#38BDF8',
          light: '#7DD3FC',
          dark: '#0EA5E9',
        },
        success: '#22C55E',
        warning: '#EAB308',
        danger: '#EF4444',
        text: {
          primary: '#F9FAFB',
          secondary: '#94A3B8',
          muted: '#64748B',
        },
        hover: 'rgba(255, 255, 255, 0.04)',
      },
      fontFamily: {
        sans: ['Inter', 'Plus Jakarta Sans', 'SF Pro Display', 'system-ui', 'sans-serif'],
      },
      fontSize: {
        'title': ['28px', { lineHeight: '1.2', fontWeight: '600' }],
        'subtitle': ['20px', { lineHeight: '1.3', fontWeight: '500' }],
        'body': ['16px', { lineHeight: '1.5', fontWeight: '400' }],
        'small': ['14px', { lineHeight: '1.4', fontWeight: '400' }],
        'label': ['12px', { lineHeight: '1.3', fontWeight: '500', letterSpacing: '0.05em' }],
      },
      boxShadow: {
        'premium': '0px 4px 24px rgba(0, 0, 0, 0.35)',
        'card': '0px 2px 12px rgba(0, 0, 0, 0.25)',
        'button': '0px 2px 8px rgba(59, 130, 246, 0.3)',
        'glow': '0 0 20px rgba(59, 130, 246, 0.4)',
      },
      spacing: {
        '128': '32rem',
        '144': '36rem',
      },
      maxWidth: {
        'container': '1440px',
      },
      animation: {
        'float': 'float 6s ease-in-out infinite',
        'glow': 'glow 2s ease-in-out infinite alternate',
      },
      keyframes: {
        float: {
          '0%, 100%': { transform: 'translateY(0px)' },
          '50%': { transform: 'translateY(-20px)' },
        },
        glow: {
          '0%': { opacity: '0.6' },
          '100%': { opacity: '1' },
        },
      },
    },
  },
  plugins: [],
}
