<?php
/**
 * Check Roasting Mode Settings
 */

require __DIR__.'/../vendor/autoload.php';
$app = require_once __DIR__.'/../bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

header('Content-Type: text/plain; charset=utf-8');

echo "=== Roasting Mode Settings Check ===\n\n";

$settings = \App\Models\Setting::where('key', 'roasting_mode')->get();

if ($settings->isEmpty()) {
    echo "No roasting_mode settings found.\n";
} else {
    foreach ($settings as $setting) {
        echo "Tenant ID: {$setting->tenant_id}\n";
        echo "Key: {$setting->key}\n";
        echo "Value (raw): " . var_export($setting->getRawOriginal('value'), true) . "\n";
        echo "Value (casted): " . var_export($setting->value, true) . "\n";
        echo "Type: " . gettype($setting->value) . "\n";
        echo "---\n";
    }
}

echo "\n=== Test Toggle Logic ===\n\n";

$testValue = '1';
echo "Test value: '{$testValue}'\n";
echo "Is '1'?: " . ($testValue === '1' ? 'YES' : 'NO') . "\n";
echo "Toggle result: " . ($testValue === '1' ? '0' : '1') . "\n";

echo "\n=== All Settings ===\n\n";
$allSettings = \App\Models\Setting::all();
foreach ($allSettings as $s) {
    echo "Tenant {$s->tenant_id} - {$s->key} = " . var_export($s->value, true) . "\n";
}
