<?php
/**
 * Test Roasting Mode Toggle
 */

require __DIR__.'/../vendor/autoload.php';
$app = require_once __DIR__.'/../bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="<?php echo csrf_token(); ?>">
    <title>Test Toggle - PHXBot</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-gray-900 text-gray-100 p-8">
    <div class="max-w-4xl mx-auto">
        <div class="bg-gray-800 rounded-lg shadow-2xl p-8 border border-gray-700">
            <h1 class="text-3xl font-bold text-purple-400 mb-6">🔥 Roasting Mode Toggle Test</h1>

            <?php
            $tenant = \App\Models\Tenant::find(16); // Your tenant ID
            if (!$tenant) {
                echo "<p class='text-red-400'>❌ Tenant #16 not found!</p>";
                echo "</body></html>";
                exit;
            }

            $currentValue = $tenant->settings()
                ->where('key', 'roasting_mode')
                ->value('value');

            $isEnabled = $currentValue === '1';
            ?>

            <div class="mb-6 bg-gray-900 p-4 rounded">
                <h2 class="text-lg font-bold text-indigo-400 mb-2">Current Status:</h2>
                <p class="text-gray-300">Tenant ID: <strong><?php echo $tenant->id; ?></strong></p>
                <p class="text-gray-300">Channel: <strong><?php echo $tenant->channel_title; ?></strong></p>
                <p class="text-gray-300">Database Value: <strong class="font-mono"><?php echo var_export($currentValue, true); ?></strong></p>
                <p class="text-gray-300">Is Enabled: <strong><?php echo $isEnabled ? 'YES (1)' : 'NO (0)'; ?></strong></p>
            </div>

            <!-- Method 1: Alpine.js Toggle (Same as Dashboard) -->
            <div class="mb-8 bg-gray-900 p-4 rounded border border-gray-700">
                <h2 class="text-lg font-bold text-indigo-400 mb-4">Method 1: Alpine.js Toggle (Dashboard Method)</h2>

                <div x-data="{
                    enabled: <?php echo $isEnabled ? 'true' : 'false'; ?>,
                    loading: false,
                    error: '',
                    success: '',
                    toggle() {
                        this.loading = true;
                        this.error = '';
                        this.success = '';

                        console.log('Toggle clicked! Current state:', this.enabled);

                        fetch('<?php echo url('/tenants/' . $tenant->id . '/settings/toggle/roasting_mode'); ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]').content,
                                'Accept': 'application/json'
                            }
                        })
                        .then(res => {
                            console.log('Response status:', res.status);
                            return res.json();
                        })
                        .then(data => {
                            console.log('Response data:', data);
                            this.enabled = data.enabled;
                            this.success = data.message || 'Toggle successful!';
                            this.loading = false;
                        })
                        .catch(err => {
                            console.error('Error:', err);
                            this.error = err.message;
                            this.loading = false;
                        });
                    }
                }" class="space-y-4">
                    <div class="flex items-center space-x-4">
                        <button @click="toggle()" :disabled="loading" type="button"
                            class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors focus:outline-none focus:ring-2 focus:ring-orange-500 focus:ring-offset-2 focus:ring-offset-gray-800 disabled:opacity-50"
                            :class="enabled ? 'bg-orange-600' : 'bg-gray-600'">
                            <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform"
                                :class="enabled ? 'translate-x-6' : 'translate-x-1'"></span>
                        </button>

                        <div class="flex items-center space-x-2">
                            <span class="text-sm font-medium text-white">🔥 Roasting Mode</span>
                            <span x-show="loading" class="text-xs text-gray-400">(saving...)</span>
                            <span x-show="enabled && !loading" class="text-xs text-green-400">✅ ON</span>
                            <span x-show="!enabled && !loading" class="text-xs text-gray-400">❌ OFF</span>
                        </div>
                    </div>

                    <div x-show="error" class="bg-red-900/30 border border-red-500 text-red-200 px-3 py-2 rounded text-sm">
                        <strong>Error:</strong> <span x-text="error"></span>
                    </div>

                    <div x-show="success" class="bg-green-900/30 border border-green-500 text-green-200 px-3 py-2 rounded text-sm">
                        <strong>Success:</strong> <span x-text="success"></span>
                    </div>
                </div>
            </div>

            <!-- Method 2: Manual Form POST -->
            <div class="mb-8 bg-gray-900 p-4 rounded border border-gray-700">
                <h2 class="text-lg font-bold text-indigo-400 mb-4">Method 2: Manual PHP Toggle</h2>

                <?php
                if (isset($_POST['manual_toggle'])) {
                    $currentVal = $tenant->settings()->where('key', 'roasting_mode')->value('value') ?? '0';
                    $newVal = $currentVal === '1' ? '0' : '1';

                    $tenant->settings()->updateOrCreate(
                        ['key' => 'roasting_mode'],
                        ['value' => $newVal]
                    );

                    echo "<div class='bg-green-900/30 border border-green-500 text-green-200 px-3 py-2 rounded text-sm mb-3'>";
                    echo "✅ Toggled! Old: '{$currentVal}' → New: '{$newVal}'";
                    echo "</div>";

                    // Refresh current value
                    $currentValue = $newVal;
                    $isEnabled = $newVal === '1';
                }
                ?>

                <form method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" name="manual_toggle" class="px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded-lg">
                        Manual Toggle (Current: <?php echo $isEnabled ? 'ON' : 'OFF'; ?>)
                    </button>
                </form>
            </div>

            <!-- Method 3: Direct Database Update -->
            <div class="bg-gray-900 p-4 rounded border border-gray-700">
                <h2 class="text-lg font-bold text-indigo-400 mb-4">Method 3: Direct Database Update</h2>

                <?php
                if (isset($_POST['set_on'])) {
                    $tenant->settings()->updateOrCreate(['key' => 'roasting_mode'], ['value' => '1']);
                    echo "<div class='bg-green-900/30 border border-green-500 text-green-200 px-3 py-2 rounded text-sm mb-3'>✅ Set to ON (1)</div>";
                    $currentValue = '1';
                    $isEnabled = true;
                }
                if (isset($_POST['set_off'])) {
                    $tenant->settings()->updateOrCreate(['key' => 'roasting_mode'], ['value' => '0']);
                    echo "<div class='bg-green-900/30 border border-green-500 text-green-200 px-3 py-2 rounded text-sm mb-3'>✅ Set to OFF (0)</div>";
                    $currentValue = '0';
                    $isEnabled = false;
                }
                ?>

                <form method="POST" class="flex space-x-2">
                    <?php echo csrf_field(); ?>
                    <button type="submit" name="set_on" class="px-4 py-2 bg-green-600 hover:bg-green-500 text-white rounded-lg">
                        Force ON
                    </button>
                    <button type="submit" name="set_off" class="px-4 py-2 bg-red-600 hover:bg-red-500 text-white rounded-lg">
                        Force OFF
                    </button>
                </form>
            </div>

            <div class="mt-6 text-center">
                <a href="/dashboard" class="text-indigo-400 hover:text-indigo-300">← Back to Dashboard</a>
            </div>
        </div>

        <!-- Console Logs -->
        <div class="mt-6 bg-gray-800 rounded-lg p-4 border border-gray-700">
            <h3 class="text-lg font-bold text-yellow-400 mb-2">📝 Browser Console Instructions:</h3>
            <ol class="text-sm text-gray-300 list-decimal list-inside space-y-1">
                <li>Press <code class="bg-gray-900 px-2 py-1 rounded">F12</code> to open Developer Tools</li>
                <li>Go to <strong>Console</strong> tab</li>
                <li>Click the Alpine.js toggle above</li>
                <li>Look for log messages and any errors</li>
                <li>Screenshot and send me if there are errors</li>
            </ol>
        </div>
    </div>
</body>
</html>
