@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-8">
        <a href="{{ route('admin.index') }}" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Admin
        </a>
        <h2 class="text-3xl font-bold text-white">Audit Logs</h2>
        <p class="mt-2 text-gray-400">System activity and changes</p>

        <!-- Admin Navigation -->
        <div class="mt-6 flex flex-wrap gap-3">
            <a href="{{ route('admin.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                </svg>
                Overview
            </a>
            <a href="{{ route('admin.quotas') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                </svg>
                Quotas
            </a>
            <a href="{{ route('admin.audits') }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-lg text-sm font-medium hover:bg-indigo-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                Audit Logs
            </a>
            <a href="{{ route('admin.settings') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                </svg>
                API Settings
            </a>
        </div>
    </div>

    <!-- Audit Logs Table -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Time</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">User</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Action</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Model</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Details</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($audits as $audit)
                    <tr class="hover:bg-gray-800/30 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-400">
                            {{ $audit->created_at->format('M d, H:i:s') }}
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm text-white">{{ $audit->user->name ?? 'System' }}</p>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-medium rounded-full
                                {{ $audit->action === 'created' ? 'bg-green-500/20 text-green-400' : '' }}
                                {{ $audit->action === 'updated' ? 'bg-blue-500/20 text-blue-400' : '' }}
                                {{ $audit->action === 'deleted' ? 'bg-red-500/20 text-red-400' : '' }}">
                                {{ ucfirst($audit->action) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-300">
                            {{ class_basename($audit->auditable_type) }} #{{ $audit->auditable_id }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-400">
                            @if($audit->changes)
                                <details class="cursor-pointer">
                                    <summary>View Changes</summary>
                                    <pre class="text-xs mt-2 p-2 bg-gray-800 rounded">{{ json_encode($audit->changes, JSON_PRETTY_PRINT) }}</pre>
                                </details>
                            @else
                                -
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-400">
                            No audit logs found
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    @if($audits->hasPages())
    <div class="mt-6">
        {{ $audits->links() }}
    </div>
    @endif
</div>
@endsection
