@extends('layouts.app')

@section('content')
<div class="min-h-[calc(100vh-4rem)] bg-body">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6 lg:py-10">

        <!-- Page Header -->
        <div class="mb-8">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-2xl lg:text-3xl font-bold text-main">Admin Dashboard</h1>
                    <p class="text-sm text-muted mt-1">System overview and tenant management</p>
                </div>
            </div>

            <!-- Admin Navigation -->
            <nav class="mt-6 flex flex-wrap gap-2">
                <a href="{{ route('admin.index') }}"
                   class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium transition-all {{ request()->routeIs('admin.index') ? 'bg-accent-primary text-white shadow-lg shadow-accent-primary/25' : 'bg-card border border-subtle text-secondary hover:text-main hover:border-hover' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                    </svg>
                    Overview
                </a>
                <a href="{{ route('admin.quotas') }}"
                   class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium transition-all {{ request()->routeIs('admin.quotas') ? 'bg-accent-primary text-white shadow-lg shadow-accent-primary/25' : 'bg-card border border-subtle text-secondary hover:text-main hover:border-hover' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                    </svg>
                    Quotas
                </a>
                <a href="{{ route('admin.audits') }}"
                   class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium transition-all {{ request()->routeIs('admin.audits') ? 'bg-accent-primary text-white shadow-lg shadow-accent-primary/25' : 'bg-card border border-subtle text-secondary hover:text-main hover:border-hover' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Audit Logs
                </a>
                <a href="{{ route('admin.settings') }}"
                   class="inline-flex items-center gap-2 px-4 py-2.5 rounded-xl text-sm font-medium transition-all {{ request()->routeIs('admin.settings') ? 'bg-accent-primary text-white shadow-lg shadow-accent-primary/25' : 'bg-card border border-subtle text-secondary hover:text-main hover:border-hover' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                    API Settings
                </a>
            </nav>
        </div>

        <!-- Bot Account Section -->
        <section class="mb-8">
            @include('dashboard.partials.bot-account')
        </section>

        <!-- Stats Grid -->
        <section class="mb-8">
            <h2 class="text-sm font-semibold text-muted uppercase tracking-wider mb-4 px-1">System Stats</h2>
            <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">
                <!-- Total Tenants -->
                <div class="group bg-card border border-subtle rounded-xl p-5 hover:border-accent-primary/40 transition-all duration-200">
                    <div class="flex items-center justify-between mb-4">
                        <span class="text-xs font-semibold text-muted uppercase tracking-wider">Tenants</span>
                        <div class="w-10 h-10 rounded-xl bg-accent-primary/10 flex items-center justify-center group-hover:bg-accent-primary/20 transition-colors">
                            <svg class="w-5 h-5 text-accent-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                        </div>
                    </div>
                    <div class="text-3xl lg:text-4xl font-bold text-main mb-1">{{ $stats['total_tenants'] ?? 0 }}</div>
                    <p class="text-xs text-muted">Total channels</p>
                </div>

                <!-- Active Tenants -->
                <div class="group bg-card border border-subtle rounded-xl p-5 hover:border-success/40 transition-all duration-200">
                    <div class="flex items-center justify-between mb-4">
                        <span class="text-xs font-semibold text-muted uppercase tracking-wider">Active</span>
                        <div class="w-10 h-10 rounded-xl bg-success/10 flex items-center justify-center group-hover:bg-success/20 transition-colors">
                            <svg class="w-5 h-5 text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                    </div>
                    <div class="text-3xl lg:text-4xl font-bold text-main mb-1">{{ $stats['active_tenants'] ?? 0 }}</div>
                    <p class="text-xs text-muted">Running bots</p>
                </div>

                <!-- Total Commands -->
                <div class="group bg-card border border-subtle rounded-xl p-5 hover:border-accent-secondary/40 transition-all duration-200">
                    <div class="flex items-center justify-between mb-4">
                        <span class="text-xs font-semibold text-muted uppercase tracking-wider">Commands</span>
                        <div class="w-10 h-10 rounded-xl bg-accent-secondary/10 flex items-center justify-center group-hover:bg-accent-secondary/20 transition-colors">
                            <svg class="w-5 h-5 text-accent-secondary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </div>
                    </div>
                    <div class="text-3xl lg:text-4xl font-bold text-main mb-1">{{ $stats['total_commands'] ?? 0 }}</div>
                    <p class="text-xs text-muted">Custom commands</p>
                </div>

                <!-- Total Messages -->
                <div class="group bg-card border border-subtle rounded-xl p-5 hover:border-warning/40 transition-all duration-200">
                    <div class="flex items-center justify-between mb-4">
                        <span class="text-xs font-semibold text-muted uppercase tracking-wider">Messages</span>
                        <div class="w-10 h-10 rounded-xl bg-warning/10 flex items-center justify-center group-hover:bg-warning/20 transition-colors">
                            <svg class="w-5 h-5 text-warning" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                            </svg>
                        </div>
                    </div>
                    <div class="text-3xl lg:text-4xl font-bold text-main mb-1">{{ $stats['total_messages'] ?? 0 }}</div>
                    <p class="text-xs text-muted">Total processed</p>
                </div>
            </div>
        </section>

        <!-- Tenants Table -->
        <section>
            <div class="flex items-center justify-between mb-4 px-1">
                <h2 class="text-sm font-semibold text-muted uppercase tracking-wider">All Tenants</h2>
                <span class="text-xs text-muted">{{ $tenants->total() }} total</span>
            </div>

            <div class="bg-card border border-subtle rounded-2xl overflow-hidden shadow-xl">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="border-b border-subtle bg-surface/50">
                                <th class="px-6 py-4 text-left text-xs font-semibold text-muted uppercase tracking-wider">Channel</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-muted uppercase tracking-wider hidden sm:table-cell">User</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-muted uppercase tracking-wider">Status</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-muted uppercase tracking-wider hidden lg:table-cell">Created</th>
                                <th class="px-6 py-4 text-right text-xs font-semibold text-muted uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-subtle">
                            @forelse($tenants as $tenant)
                            <tr class="hover:bg-surface/30 transition-colors">
                                <td class="px-6 py-4">
                                    <div class="flex items-center gap-3">
                                        @if($tenant->channel_avatar_url)
                                        <img src="{{ $tenant->channel_avatar_url }}" class="w-10 h-10 rounded-lg object-cover" alt="Avatar">
                                        @else
                                        <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-accent-primary to-accent-secondary flex items-center justify-center">
                                            <span class="text-white text-sm font-bold">{{ strtoupper(substr($tenant->channel_title, 0, 1)) }}</span>
                                        </div>
                                        @endif
                                        <div class="min-w-0">
                                            <p class="text-sm font-semibold text-main truncate">{{ $tenant->channel_title }}</p>
                                            <p class="text-xs text-muted font-mono truncate">{{ $tenant->channel_id }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 hidden sm:table-cell">
                                    <p class="text-sm text-secondary">{{ $tenant->user->name }}</p>
                                    <p class="text-xs text-muted truncate">{{ $tenant->user->email }}</p>
                                </td>
                                <td class="px-6 py-4">
                                    @if($tenant->status === 'running')
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-semibold bg-success/15 text-success border border-success/25">
                                        <span class="w-1.5 h-1.5 rounded-full bg-success animate-pulse"></span>
                                        Running
                                    </span>
                                    @elseif($tenant->status === 'error')
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-semibold bg-danger/15 text-danger border border-danger/25">
                                        <span class="w-1.5 h-1.5 rounded-full bg-danger"></span>
                                        Error
                                    </span>
                                    @else
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-semibold bg-surface text-muted border border-subtle">
                                        <span class="w-1.5 h-1.5 rounded-full bg-gray-500"></span>
                                        Stopped
                                    </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 hidden lg:table-cell">
                                    <p class="text-sm text-muted">{{ $tenant->created_at->format('M d, Y') }}</p>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center justify-end gap-2">
                                        <a href="{{ route('admin.tenants.logs', $tenant) }}"
                                           class="inline-flex items-center justify-center w-8 h-8 rounded-lg bg-surface hover:bg-surface-hover text-muted hover:text-main border border-subtle transition-colors"
                                           title="View Logs">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                            </svg>
                                        </a>
                                        <a href="{{ route('tenant.commands.index', $tenant) }}"
                                           class="inline-flex items-center justify-center w-8 h-8 rounded-lg bg-accent-primary/10 hover:bg-accent-primary/20 text-accent-primary border border-accent-primary/20 transition-colors"
                                           title="View Details">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                            </svg>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="px-6 py-16 text-center">
                                    <div class="flex flex-col items-center">
                                        <div class="w-16 h-16 rounded-2xl bg-surface flex items-center justify-center mb-4">
                                            <svg class="w-8 h-8 text-muted" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                                            </svg>
                                        </div>
                                        <p class="text-muted">No tenants found</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            @if($tenants->hasPages())
            <div class="mt-6 flex justify-center">
                {{ $tenants->links() }}
            </div>
            @endif
        </section>

    </div>
</div>
@endsection
