@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-8">
        <a href="{{ route('admin.index') }}" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Admin
        </a>
        <h2 class="text-3xl font-bold text-white">Quota Management</h2>
        <p class="mt-2 text-gray-400">Manage message rate limits for each tenant</p>

        <!-- Admin Navigation -->
        <div class="mt-6 flex flex-wrap gap-3">
            <a href="{{ route('admin.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                </svg>
                Overview
            </a>
            <a href="{{ route('admin.quotas') }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-lg text-sm font-medium hover:bg-indigo-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                </svg>
                Quotas
            </a>
            <a href="{{ route('admin.audits') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                Audit Logs
            </a>
            <a href="{{ route('admin.settings') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                </svg>
                API Settings
            </a>
        </div>
    </div>

    @if(session('success'))
    <div class="mb-6 bg-green-500/20 border border-green-500/50 text-green-400 px-6 py-4 rounded-xl">
        {{ session('success') }}
    </div>
    @endif

    @if($errors->any())
    <div class="mb-6 bg-red-500/20 border border-red-500/50 text-red-400 px-6 py-4 rounded-xl">
        <ul class="list-disc list-inside">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <!-- Quotas Table -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-700">
            <h3 class="text-xl font-bold text-white">Tenant Message Quotas</h3>
            <p class="text-sm text-gray-400 mt-1">Default: 200/min, 2000/hour</p>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Channel</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">User</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Status</th>
                        <th class="px-6 py-4 text-center text-xs font-semibold text-gray-300 uppercase">Per Minute</th>
                        <th class="px-6 py-4 text-center text-xs font-semibold text-gray-300 uppercase">Per Hour</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-gray-300 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($tenants as $tenant)
                    <tr class="hover:bg-gray-800/30 transition-colors" x-data="{ editing: false }">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                @if($tenant->channel_avatar_url)
                                <img src="{{ $tenant->channel_avatar_url }}" class="w-10 h-10 rounded-full mr-3" alt="Avatar">
                                @endif
                                <div>
                                    <p class="text-sm font-medium text-white">{{ $tenant->channel_title }}</p>
                                    <p class="text-xs text-gray-400">{{ Str::limit($tenant->channel_id, 20) }}</p>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm text-gray-300">{{ $tenant->user->name }}</p>
                            <p class="text-xs text-gray-400">{{ $tenant->user->email }}</p>
                        </td>
                        <td class="px-6 py-4">
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full
                                {{ $tenant->status === 'running' ? 'bg-green-500/20 text-green-400' : '' }}
                                {{ $tenant->status === 'stopped' ? 'bg-gray-500/20 text-gray-400' : '' }}
                                {{ $tenant->status === 'error' ? 'bg-red-500/20 text-red-400' : '' }}">
                                {{ ucfirst($tenant->status) }}
                            </span>
                        </td>

                        <!-- Display Mode -->
                        <td class="px-6 py-4 text-center" x-show="!editing">
                            <span class="text-lg font-bold text-indigo-400">
                                {{ $tenant->quotas['per_minute'] ?? 200 }}
                            </span>
                            <span class="text-xs text-gray-400 block">messages/min</span>
                        </td>
                        <td class="px-6 py-4 text-center" x-show="!editing">
                            <span class="text-lg font-bold text-indigo-400">
                                {{ $tenant->quotas['per_hour'] ?? 2000 }}
                            </span>
                            <span class="text-xs text-gray-400 block">messages/hour</span>
                        </td>

                        <!-- Edit Mode -->
                        <td class="px-6 py-4 text-center" x-show="editing" style="display: none;">
                            <form action="{{ route('admin.tenants.quota', $tenant) }}" method="POST" class="inline-flex items-center gap-2">
                                @csrf
                                <input type="number" name="per_minute"
                                    value="{{ $tenant->quotas['per_minute'] ?? 200 }}"
                                    min="1" max="1000" required
                                    class="w-20 px-2 py-1 bg-gray-700 border border-gray-600 rounded text-white text-sm focus:ring-2 focus:ring-indigo-500">
                        </td>
                        <td class="px-6 py-4 text-center" x-show="editing" style="display: none;">
                                <input type="number" name="per_hour"
                                    value="{{ $tenant->quotas['per_hour'] ?? 2000 }}"
                                    min="1" max="10000" required
                                    class="w-20 px-2 py-1 bg-gray-700 border border-gray-600 rounded text-white text-sm focus:ring-2 focus:ring-indigo-500">
                        </td>

                        <td class="px-6 py-4 text-right">
                            <!-- Edit Button -->
                            <button type="button" @click="editing = true" x-show="!editing"
                                class="inline-flex items-center px-3 py-1 bg-indigo-600 hover:bg-indigo-700 text-white text-xs font-medium rounded transition-colors">
                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                </svg>
                                Edit
                            </button>

                            <!-- Save/Cancel Buttons -->
                            <div x-show="editing" style="display: none;" class="inline-flex gap-2">
                                <button type="submit"
                                    class="inline-flex items-center px-3 py-1 bg-green-600 hover:bg-green-700 text-white text-xs font-medium rounded transition-colors">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                    </svg>
                                    Save
                                </button>
                                <button type="button" @click="editing = false"
                                    class="inline-flex items-center px-3 py-1 bg-gray-600 hover:bg-gray-700 text-white text-xs font-medium rounded transition-colors">
                                    Cancel
                                </button>
                            </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center text-gray-400">
                            No tenants found
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Info Panel -->
    <div class="mt-6 bg-blue-500/10 border border-blue-500/30 rounded-xl p-6">
        <div class="flex items-start">
            <svg class="w-6 h-6 text-blue-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            <div>
                <h4 class="text-white font-semibold mb-2">About Quotas</h4>
                <ul class="text-sm text-gray-300 space-y-1">
                    <li>• <strong>Per Minute:</strong> Maximum messages the bot can send per minute (1-1000)</li>
                    <li>• <strong>Per Hour:</strong> Maximum messages the bot can send per hour (1-10000)</li>
                    <li>• <strong>Default Values:</strong> 200 messages/minute, 2000 messages/hour</li>
                    <li>• <strong>Rate Limiting:</strong> Prevents YouTube API quota exhaustion and spam</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
