@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-8">
        <a href="{{ route('admin.index') }}" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Admin
        </a>
        <h2 class="text-3xl font-bold text-white">API Settings</h2>
        <p class="mt-2 text-gray-400">Manage OpenAI and YouTube API configurations</p>

        <!-- Admin Navigation -->
        <div class="mt-6 flex flex-wrap gap-3">
            <a href="{{ route('admin.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                </svg>
                Overview
            </a>
            <a href="{{ route('admin.quotas') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                </svg>
                Quotas
            </a>
            <a href="{{ route('admin.audits') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 text-gray-300 rounded-lg text-sm font-medium hover:bg-gray-600 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                Audit Logs
            </a>
            <a href="{{ route('admin.settings') }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-lg text-sm font-medium hover:bg-indigo-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                </svg>
                API Settings
            </a>
        </div>
    </div>

    <!-- OpenAI Settings -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden mb-6">
        <div class="px-6 py-4 border-b border-gray-700 bg-gradient-to-r from-green-600/20 to-emerald-600/20">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-xl font-bold text-white flex items-center">
                        <svg class="w-6 h-6 mr-2 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z" />
                        </svg>
                        OpenAI API Settings
                    </h3>
                    <p class="text-sm text-gray-400 mt-1">Configure GPT model and parameters</p>
                </div>
                <button onclick="testOpenAI()" class="px-4 py-2 bg-green-600 hover:bg-green-500 text-white rounded-lg text-sm font-medium transition-colors">
                    <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Test API
                </button>
            </div>
        </div>

        <form method="POST" action="{{ route('admin.settings.openai') }}" class="p-6">
            @csrf
            <div class="grid md:grid-cols-2 gap-6">
                <!-- API Key -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-300 mb-2">
                        API Key
                        <span class="text-red-400">*</span>
                    </label>
                    <input type="text" name="api_key" required
                        class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:ring-2 focus:ring-green-500 focus:border-transparent"
                        placeholder="sk-proj-...">
                    <p class="text-xs text-gray-400 mt-1">Get from: <a href="https://platform.openai.com/api-keys" target="_blank" class="text-green-400 hover:underline">platform.openai.com/api-keys</a></p>
                </div>

                <!-- Model -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">
                        Model
                        <span class="text-red-400">*</span>
                    </label>
                    <select name="model" required class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:ring-2 focus:ring-green-500">
                        <option value="gpt-4o-mini" {{ $settings['openai_model'] === 'gpt-4o-mini' ? 'selected' : '' }}>GPT-4o Mini (Fastest, Cheapest)</option>
                        <option value="gpt-4o" {{ $settings['openai_model'] === 'gpt-4o' ? 'selected' : '' }}>GPT-4o (Balanced)</option>
                        <option value="gpt-4-turbo" {{ $settings['openai_model'] === 'gpt-4-turbo' ? 'selected' : '' }}>GPT-4 Turbo (Smart)</option>
                        <option value="gpt-3.5-turbo" {{ $settings['openai_model'] === 'gpt-3.5-turbo' ? 'selected' : '' }}>GPT-3.5 Turbo (Budget)</option>
                    </select>
                    <p class="text-xs text-gray-400 mt-1">Recommended: GPT-4o Mini</p>
                </div>

                <!-- Temperature -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">
                        Temperature (0-2)
                        <span class="text-red-400">*</span>
                    </label>
                    <input type="number" name="temperature" step="0.1" min="0" max="2" value="{{ $settings['openai_temperature'] }}" required
                        class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:ring-2 focus:ring-green-500">
                    <p class="text-xs text-gray-400 mt-1">Lower = More focused, Higher = More creative</p>
                </div>

                <!-- Max Tokens -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">
                        Max Tokens (50-1000)
                        <span class="text-red-400">*</span>
                    </label>
                    <input type="number" name="max_tokens" min="50" max="1000" value="{{ $settings['openai_max_tokens'] }}" required
                        class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:ring-2 focus:ring-green-500">
                    <p class="text-xs text-gray-400 mt-1">Lower = Faster responses, Lower cost</p>
                </div>
            </div>

            <div class="mt-6 flex gap-3">
                <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-500 text-white rounded-lg font-medium transition-colors">
                    Save OpenAI Settings
                </button>
            </div>
        </form>
    </div>

    <!-- Google/YouTube API Settings -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden mb-6">
        <div class="px-6 py-4 border-b border-gray-700 bg-gradient-to-r from-red-600/20 to-pink-600/20">
            <h3 class="text-xl font-bold text-white flex items-center">
                <svg class="w-6 h-6 mr-2 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                </svg>
                Google/YouTube API Settings
            </h3>
            <p class="text-sm text-gray-400 mt-1">OAuth credentials for YouTube integration</p>
        </div>

        <form method="POST" action="{{ route('admin.settings.google') }}" class="p-6">
            @csrf
            <div class="grid md:grid-cols-2 gap-6">
                <!-- Client ID -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-300 mb-2">
                        Client ID
                        <span class="text-red-400">*</span>
                    </label>
                    <input type="text" name="client_id" required
                        class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:ring-2 focus:ring-red-500 focus:border-transparent"
                        placeholder="xxxxx.apps.googleusercontent.com">
                    <p class="text-xs text-gray-400 mt-1">Get from: <a href="https://console.cloud.google.com/apis/credentials" target="_blank" class="text-red-400 hover:underline">Google Cloud Console</a></p>
                </div>

                <!-- Client Secret -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-300 mb-2">
                        Client Secret
                        <span class="text-red-400">*</span>
                    </label>
                    <input type="text" name="client_secret" required
                        class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:ring-2 focus:ring-red-500 focus:border-transparent"
                        placeholder="GOCSPX-...">
                </div>
            </div>

            <div class="mt-6 flex gap-3">
                <button type="submit" class="px-6 py-2 bg-red-600 hover:bg-red-500 text-white rounded-lg font-medium transition-colors">
                    Save YouTube Settings
                </button>
            </div>
        </form>
    </div>

    <!-- Info Panel -->
    <div class="bg-blue-500/10 border border-blue-500/30 rounded-xl p-6">
        <div class="flex items-start">
            <svg class="w-6 h-6 text-blue-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            <div>
                <h4 class="text-white font-semibold mb-2">Important Notes</h4>
                <ul class="text-sm text-gray-300 space-y-1">
                    <li>• API keys are stored securely in .env file</li>
                    <li>• Config cache is automatically cleared after updates</li>
                    <li>• Changes take effect immediately</li>
                    <li>• All API updates are logged in audit logs</li>
                    <li>• Test OpenAI API before saving to verify it works</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
function testOpenAI() {
    const button = event.target.closest('button');
    const originalText = button.innerHTML;
    button.disabled = true;
    button.innerHTML = '<svg class="animate-spin h-4 w-4 inline mr-1" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Testing...';

    fetch('/admin/settings/test-openai', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(res => res.json())
    .then(data => {
        button.disabled = false;
        button.innerHTML = originalText;

        if (data.success) {
            alert('✅ OpenAI API Test Successful!\n\nTest Result:\n' + JSON.stringify(data.test_result, null, 2));
        } else {
            alert('❌ OpenAI API Test Failed!\n\n' + data.message);
        }
    })
    .catch(err => {
        button.disabled = false;
        button.innerHTML = originalText;
        alert('❌ Error testing API: ' + err.message);
    });
}
</script>
@endsection
