<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - DAYBot</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class'
        }
    </script>
</head>
<body class="bg-gray-900 text-white min-h-screen flex items-center justify-center py-12">
    <div class="w-full max-w-md p-8 bg-gray-800 rounded-lg shadow-xl">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-purple-400 mb-2">DAYBot</h1>
            <p class="text-gray-400">Create your account</p>
        </div>

        @if(session('error'))
            <div class="bg-red-500/10 border border-red-500 text-red-500 px-4 py-3 rounded mb-4">
                {{ session('error') }}
            </div>
        @endif

        @if(session('success'))
            <div class="bg-green-500/10 border border-green-500 text-green-500 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        <form method="POST" action="{{ route('register.post') }}">
            @csrf

            <div class="mb-4">
                <label for="name" class="block text-sm font-medium text-gray-300 mb-2">Name</label>
                <input
                    type="text"
                    id="name"
                    name="name"
                    required
                    class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent text-white"
                    placeholder="Your Name"
                    value="{{ old('name') }}"
                >
                @error('name')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="email" class="block text-sm font-medium text-gray-300 mb-2">Email</label>
                <input
                    type="email"
                    id="email"
                    name="email"
                    required
                    class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent text-white"
                    placeholder="your@email.com"
                    value="{{ old('email') }}"
                >
                @error('email')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="password" class="block text-sm font-medium text-gray-300 mb-2">Password</label>
                <input
                    type="password"
                    id="password"
                    name="password"
                    required
                    class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent text-white"
                    placeholder="••••••••"
                >
                @error('password')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
                <p class="text-xs text-gray-500 mt-1">Minimum 8 characters</p>
            </div>

            <div class="mb-4">
                <label for="password_confirmation" class="block text-sm font-medium text-gray-300 mb-2">Confirm Password</label>
                <input
                    type="password"
                    id="password_confirmation"
                    name="password_confirmation"
                    required
                    class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent text-white"
                    placeholder="••••••••"
                >
            </div>

            <!-- Terms & Privacy Policy Checkbox -->
            <div class="mb-6">
                <div class="flex items-start">
                    <input
                        type="checkbox"
                        id="terms_accepted"
                        name="terms_accepted"
                        value="1"
                        required
                        class="w-4 h-4 mt-1 bg-gray-700 border-gray-600 rounded focus:ring-2 focus:ring-purple-500 text-purple-600"
                    >
                    <label for="terms_accepted" class="ml-3 text-sm text-gray-300">
                        I agree to the
                        <a href="{{ route('terms-of-service') }}" target="_blank" class="text-purple-400 hover:text-purple-300 underline">Terms of Service</a>
                        and
                        <a href="{{ route('privacy-policy') }}" target="_blank" class="text-purple-400 hover:text-purple-300 underline">Privacy Policy</a>
                    </label>
                </div>
                @error('terms_accepted')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <button
                type="submit"
                class="w-full bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-4 rounded-lg transition duration-200"
            >
                Create Account
            </button>
        </form>

        <div class="mt-6 text-center">
            <p class="text-gray-400">
                Already have an account?
                <a href="{{ route('login') }}" class="text-purple-400 hover:text-purple-300">Sign in</a>
            </p>
        </div>

        <div class="mt-6 text-center">
            <a href="/" class="text-sm text-gray-500 hover:text-gray-400">← Back to home</a>
        </div>
    </div>
</body>
</html>
