{{-- Bot Account Section --}}
<div class="bg-gradient-to-br from-purple-900/20 to-indigo-900/20 border border-purple-500/30 rounded-2xl p-6 shadow-lg">
    <div class="flex items-start justify-between mb-6">
        <div>
            <h3 class="text-xl font-semibold text-main mb-2 flex items-center">
                <svg class="w-6 h-6 mr-2 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z" />
                </svg>
                Bot Account
                @if(!Auth::user()->isAdmin())
                    <span class="ml-2 px-2 py-0.5 bg-amber-900/30 border border-amber-500/30 text-amber-300 text-xs rounded-full">Admin Only</span>
                @endif
            </h3>
            <p class="text-sm text-muted">Centralized bot channel for all users - Replies from dedicated account</p>
        </div>
    </div>

    @if($botAccount && $botAccount->is_connected)
        {{-- Bot Account Connected --}}
        <div class="bg-card/50 border border-subtle rounded-xl p-4 mb-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-indigo-600 rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div>
                        <p class="text-base font-semibold text-main">{{ $botAccount->channel_title }}</p>
                        <p class="text-sm text-muted">{{ $botAccount->channel_handle ?? $botAccount->channel_id }}</p>
                        <p class="text-xs text-success mt-1 flex items-center">
                            <span class="w-2 h-2 bg-success rounded-full mr-2 animate-pulse"></span>
                            Connected & Active
                        </p>
                    </div>
                </div>
                @if(Auth::user()->isAdmin())
                    <form action="{{ route('bot-account.disconnect') }}" method="POST">
                        @csrf
                        <button type="submit"
                                class="px-4 py-2 bg-danger/10 hover:bg-danger/20 text-danger text-sm font-medium rounded-lg border border-danger/30 transition-colors"
                                onclick="return confirm('Are you sure you want to disconnect the bot account? All users will be affected.')">
                            Disconnect
                        </button>
                    </form>
                @endif
            </div>
        </div>

        {{-- Instructions for Moderator --}}
        <div class="bg-amber-900/20 border border-amber-500/30 rounded-xl p-4">
            <div class="flex items-start space-x-3">
                <svg class="w-5 h-5 text-amber-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                </svg>
                <div class="flex-1">
                    <h4 class="text-sm font-semibold text-amber-300 mb-2">⚠️ Important: Make Bot a Moderator</h4>
                    <p class="text-sm text-amber-200/80 mb-3">For the bot to reply in your live stream chat, you must add <strong>{{ $botAccount->channel_title }}</strong> as a moderator.</p>

                    <div class="bg-surface/50 rounded-lg p-3 space-y-2 text-sm text-secondary">
                        <p class="font-semibold text-main mb-2">How to add as moderator:</p>
                        <ol class="list-decimal list-inside space-y-1.5 ml-2">
                            <li>Go to your <a href="https://studio.youtube.com" target="_blank" class="text-accent-primary hover:underline">YouTube Studio</a></li>
                            <li>Click on <strong>Settings</strong> → <strong>Community</strong></li>
                            <li>Under "Moderators", click <strong>Add</strong></li>
                            <li>Search for: <code class="px-2 py-0.5 bg-card rounded text-accent-primary font-mono text-xs">{{ $botAccount->channel_handle ?? $botAccount->channel_title }}</code></li>
                            <li>Click "Save" to confirm</li>
                        </ol>
                        <p class="mt-3 text-xs text-muted italic">💡 Without moderator permissions, the bot cannot send messages in your chat.</p>
                    </div>
                </div>
            </div>
        </div>
    @else
        {{-- Bot Account Not Connected --}}
        <div class="text-center py-8">
            <div class="w-16 h-16 bg-gradient-to-br from-purple-500/20 to-indigo-600/20 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                </svg>
            </div>
            <h4 class="text-lg font-semibold text-main mb-2">No Bot Account Connected</h4>
            <p class="text-sm text-muted mb-6 max-w-md mx-auto">
                @if(Auth::user()->isAdmin())
                    Connect the bot's YouTube channel (<a href="https://www.youtube.com/@Daybot_01" target="_blank" class="text-accent-primary hover:underline">https://www.youtube.com/@Daybot_01</a>) to reply from a dedicated account for all users
                @else
                    The admin needs to connect a bot account. Once connected, all replies will come from the bot's channel instead of your own.
                @endif
            </p>

            @if(Auth::user()->isAdmin())
                <a href="{{ route('bot-account.oauth.redirect') }}"
                   class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-500 hover:to-indigo-500 text-white text-sm font-medium rounded-lg shadow-lg hover:shadow-xl transition-all">
                    <svg class="w-5 h-5 mr-2" viewBox="0 0 24 24">
                        <path fill="currentColor" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                        <path fill="currentColor" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                        <path fill="currentColor" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                        <path fill="currentColor" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                    </svg>
                    Connect Bot Account (Admin Only)
                </a>
            @else
                <div class="inline-flex items-center px-6 py-3 bg-gray-700/50 text-gray-400 text-sm font-medium rounded-lg cursor-not-allowed">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                    Admin Access Required
                </div>
            @endif

            <div class="mt-6 bg-card/30 border border-subtle rounded-lg p-4 max-w-md mx-auto text-left">
                <p class="text-xs text-muted mb-2"><strong class="text-main">Benefits:</strong></p>
                <ul class="text-xs text-secondary space-y-1 ml-4">
                    <li>✅ Professional branding (replies from <a href="https://www.youtube.com/@Daybot_01" target="_blank" class="text-accent-primary hover:underline">https://www.youtube.com/@Daybot_01</a>)</li>
                    <li>✅ Keeps your personal channel separate</li>
                    <li>✅ Better trust from viewers</li>
                    <li>✅ Easy to identify bot responses</li>
                </ul>
            </div>
        </div>
    @endif
</div>
