{{-- Moderator Setup Tutorial --}}
<div class="bg-gradient-to-br from-blue-900/20 to-cyan-900/20 border border-blue-500/30 rounded-2xl p-6 shadow-lg mb-6">
    <div class="flex items-start justify-between mb-4">
        <div class="flex items-start space-x-3">
            <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-full flex items-center justify-center flex-shrink-0">
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                </svg>
            </div>
            <div class="flex-1">
                <h3 class="text-xl font-semibold text-main mb-2">📚 How to Setup DAYBot as Moderator</h3>
                <p class="text-sm text-muted mb-4">Follow these steps to give DAYBot moderator permissions in your YouTube live stream chat</p>
            </div>
        </div>
    </div>

    <div class="bg-card/50 border border-subtle rounded-xl p-5">
        <div class="space-y-4">
            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-blue-500/20 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                    <span class="text-blue-400 font-bold text-sm">1</span>
                </div>
                <div class="flex-1">
                    <h4 class="text-base font-semibold text-main mb-1">Open YouTube Studio</h4>
                    <p class="text-sm text-muted">Go to <a href="https://studio.youtube.com" target="_blank" class="text-accent-primary hover:underline">studio.youtube.com</a> and login with your channel account</p>
                </div>
            </div>

            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-blue-500/20 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                    <span class="text-blue-400 font-bold text-sm">2</span>
                </div>
                <div class="flex-1">
                    <h4 class="text-base font-semibold text-main mb-1">Navigate to Settings</h4>
                    <p class="text-sm text-muted">Click on <strong class="text-white">Settings</strong> from the left sidebar</p>
                </div>
            </div>

            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-blue-500/20 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                    <span class="text-blue-400 font-bold text-sm">3</span>
                </div>
                <div class="flex-1">
                    <h4 class="text-base font-semibold text-main mb-1">Go to Community Tab</h4>
                    <p class="text-sm text-muted">Click on <strong class="text-white">Community</strong> tab in the settings menu</p>
                </div>
            </div>

            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-blue-500/20 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                    <span class="text-blue-400 font-bold text-sm">4</span>
                </div>
                <div class="flex-1">
                    <h4 class="text-base font-semibold text-main mb-1">Add Moderator</h4>
                    <p class="text-sm text-muted mb-2">Under the "Moderators" section, click <strong class="text-white">Add</strong></p>
                    <div class="bg-blue-900/20 border border-blue-500/30 rounded-lg p-3 mt-2">
                        <p class="text-sm text-blue-300 mb-1">Search for this channel:</p>
                        <a href="https://www.youtube.com/@Daybot_01" target="_blank" class="px-3 py-1.5 bg-card rounded text-accent-primary hover:text-accent-secondary font-mono text-sm inline-block hover:bg-surface transition-colors">
                            https://www.youtube.com/@Daybot_01
                        </a>
                    </div>
                </div>
            </div>

            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-blue-500/20 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                    <span class="text-blue-400 font-bold text-sm">5</span>
                </div>
                <div class="flex-1">
                    <h4 class="text-base font-semibold text-main mb-1">Save Changes</h4>
                    <p class="text-sm text-muted">Click <strong class="text-white">Save</strong> to confirm and grant moderator permissions</p>
                </div>
            </div>

            <div class="flex items-start space-x-3">
                <div class="w-8 h-8 bg-green-500/20 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                    <svg class="w-4 h-4 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                    </svg>
                </div>
                <div class="flex-1">
                    <h4 class="text-base font-semibold text-green-400 mb-1">Done! 🎉</h4>
                    <p class="text-sm text-muted">DAYBot can now reply in your live stream chat as a moderator!</p>
                </div>
            </div>
        </div>

        <div class="mt-5 pt-4 border-t border-subtle">
            <div class="flex items-start space-x-2">
                <svg class="w-5 h-5 text-amber-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                </svg>
                <div class="flex-1">
                    <p class="text-xs text-amber-300 font-semibold mb-1">⚠️ Important Note</p>
                    <p class="text-xs text-muted">Without moderator permissions, DAYBot cannot send messages in your live stream chat. Make sure to complete this setup before starting your stream!</p>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-4 flex items-center justify-between">
        <div class="flex items-center space-x-2">
            <svg class="w-5 h-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
            </svg>
            <span class="text-sm text-green-400 font-medium">Quick & Easy Setup</span>
        </div>
        <a href="https://studio.youtube.com" target="_blank" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-500 text-white text-sm font-medium rounded-lg transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
            </svg>
            Open YouTube Studio
        </a>
    </div>
</div>
