@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-8">
        <a href="{{ route('tenant.commands.index', $tenant) }}" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Commands
        </a>
        <h2 class="text-3xl font-bold text-white">Create Command</h2>
        <p class="mt-2 text-gray-400">Add a new custom command for <span class="text-indigo-400">{{ $tenant->channel_title }}</span></p>
    </div>

    <!-- Form -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl p-6 sm:p-8">
        <form method="POST" action="{{ route('tenant.commands.store', $tenant) }}" class="space-y-6">
            @csrf

            <!-- Command Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-300 mb-2">
                    Command Name <span class="text-red-400">*</span>
                </label>
                <div class="relative">
                    <span class="absolute inset-y-0 left-0 pl-4 flex items-center text-gray-400 text-lg font-mono">!</span>
                    <input
                        type="text"
                        id="name"
                        name="name"
                        required
                        value="{{ old('name') }}"
                        placeholder="hello"
                        class="pl-8 w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                    >
                </div>
                @error('name')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">Alphanumeric characters only, no spaces</p>
            </div>

            <!-- Response -->
            <div>
                <label for="response" class="block text-sm font-medium text-gray-300 mb-2">
                    Response <span class="text-red-400">*</span>
                </label>
                <textarea
                    id="response"
                    name="response"
                    required
                    rows="4"
                    placeholder="Hello! Welcome to the stream!"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all resize-y"
                >{{ old('response') }}</textarea>
                @error('response')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">The message that will be sent when this command is used</p>
            </div>

            <!-- Cooldown -->
            <div>
                <label for="cooldown_sec" class="block text-sm font-medium text-gray-300 mb-2">
                    Cooldown (seconds)
                </label>
                <input
                    type="number"
                    id="cooldown_sec"
                    name="cooldown_sec"
                    min="0"
                    value="{{ old('cooldown_sec', 5) }}"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                @error('cooldown_sec')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">Minimum time between command uses</p>
            </div>

            <!-- Required Role -->
            <div>
                <label for="required_role" class="block text-sm font-medium text-gray-300 mb-2">
                    Required Role
                </label>
                <select
                    id="required_role"
                    name="required_role"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                    <option value="viewer" {{ old('required_role', 'viewer') == 'viewer' ? 'selected' : '' }}>👁️ Viewer (Everyone)</option>
                    <option value="trusted" {{ old('required_role') == 'trusted' ? 'selected' : '' }}>💎 Trusted (Members Only)</option>
                    <option value="mod" {{ old('required_role') == 'mod' ? 'selected' : '' }}>🛡️ Moderator</option>
                    <option value="admin" {{ old('required_role') == 'admin' ? 'selected' : '' }}>⭐ Admin</option>
                    <option value="owner" {{ old('required_role') == 'owner' ? 'selected' : '' }}>🔧 Owner</option>
                </select>
                @error('required_role')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">Minimum role required to use this command</p>
            </div>

            <!-- Enabled -->
            <div class="flex items-center">
                <input
                    type="checkbox"
                    id="is_enabled"
                    name="is_enabled"
                    value="1"
                    {{ old('is_enabled', true) ? 'checked' : '' }}
                    class="w-4 h-4 text-indigo-600 bg-gray-700 border-gray-600 rounded focus:ring-2 focus:ring-indigo-500"
                >
                <label for="is_enabled" class="ml-3 text-sm font-medium text-gray-300">
                    Enable this command
                </label>
            </div>

            <!-- Submit -->
            <div class="flex justify-end space-x-3 pt-4">
                <a
                    href="{{ route('tenant.commands.index', $tenant) }}"
                    class="px-6 py-3 bg-gray-700 hover:bg-gray-600 text-gray-300 rounded-lg font-medium transition-colors"
                >
                    Cancel
                </a>
                <button
                    type="submit"
                    class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-500 hover:to-purple-500 text-white rounded-lg font-medium shadow-lg transform hover:scale-105 transition-all duration-200"
                >
                    Create Command
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
