<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Daybot - Professional YouTube live chat automation and moderation bot. AI-powered responses, custom commands, smart moderation, and real-time analytics for streamers.">
    <meta name="keywords" content="YouTube bot, live chat bot, chat moderation, streaming bot, Nightbot alternative, YouTube automation">
    <meta property="og:title" content="Daybot - YouTube Live Chat Automation & Moderation Bot">
    <meta property="og:description" content="Professional chat automation and moderation for YouTube live streams. AI responses, custom commands, and powerful moderation tools.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://daybot.tv">
    <title>Daybot - YouTube Live Chat Automation & Moderation Bot</title>

    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        /* Custom animations and gradients */
        @keyframes gradient-shift {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        .gradient-animate {
            background-size: 200% 200%;
            animation: gradient-shift 8s ease infinite;
        }

        .glass-effect {
            background: rgba(255, 255, 255, 0.03);
            backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .feature-card {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .feature-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(139, 92, 246, 0.15);
        }

        .step-number {
            background: linear-gradient(135deg, #8B5CF6 0%, #6366F1 100%);
        }
    </style>
</head>
<body class="bg-gray-950 text-gray-100 antialiased">

    <!-- Navigation -->
    <nav class="fixed top-0 w-full z-50 glass-effect border-b border-white/5">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <!-- Logo -->
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                        </svg>
                    </div>
                    <span class="text-xl font-bold bg-gradient-to-r from-purple-400 to-indigo-400 bg-clip-text text-transparent">Daybot</span>
                </div>

                <!-- Desktop Navigation -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#features" class="text-gray-300 hover:text-white transition-colors">Features</a>
                    <a href="#how-it-works" class="text-gray-300 hover:text-white transition-colors">How It Works</a>
                    <a href="#data-usage" class="text-gray-300 hover:text-white transition-colors">Data & Privacy</a>
                    <a href="{{ route('privacy-policy') }}" class="text-gray-300 hover:text-white transition-colors">Privacy</a>
                    @auth
                        <a href="{{ route('dashboard') }}" class="px-6 py-2.5 bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-500 hover:to-indigo-500 rounded-lg font-medium transition-all">
                            Dashboard
                        </a>
                    @else
                        <a href="{{ route('login') }}" class="px-6 py-2.5 bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-500 hover:to-indigo-500 rounded-lg font-medium transition-all shadow-lg shadow-purple-500/30">
                            Sign in with Google
                        </a>
                    @endauth
                </div>

                <!-- Mobile Menu Button -->
                <button class="md:hidden p-2 rounded-lg hover:bg-white/5" onclick="toggleMobileMenu()">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobileMenu" class="hidden md:hidden glass-effect border-t border-white/5">
            <div class="px-4 py-4 space-y-3">
                <a href="#features" class="block px-4 py-2 rounded-lg hover:bg-white/5 transition-colors">Features</a>
                <a href="#how-it-works" class="block px-4 py-2 rounded-lg hover:bg-white/5 transition-colors">How It Works</a>
                <a href="#data-usage" class="block px-4 py-2 rounded-lg hover:bg-white/5 transition-colors">Data & Privacy</a>
                <a href="{{ route('privacy-policy') }}" class="block px-4 py-2 rounded-lg hover:bg-white/5 transition-colors">Privacy</a>
                @auth
                    <a href="{{ route('dashboard') }}" class="block px-4 py-2 bg-gradient-to-r from-purple-600 to-indigo-600 rounded-lg font-medium text-center">Dashboard</a>
                @else
                    <a href="{{ route('login') }}" class="block px-4 py-2 bg-gradient-to-r from-purple-600 to-indigo-600 rounded-lg font-medium text-center">Sign in with Google</a>
                @endauth
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="relative pt-32 pb-20 px-4 sm:px-6 lg:px-8 overflow-hidden">
        <!-- Background Gradient -->
        <div class="absolute inset-0 bg-gradient-to-br from-purple-900/20 via-gray-950 to-indigo-900/20 gradient-animate"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSI2MCIgaGVpZ2h0PSI2MCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAxMCAwIEwgMCAwIDAgMTAiIGZpbGw9Im5vbmUiIHN0cm9rZT0icmdiYSgyNTUsMjU1LDI1NSwwLjAzKSIgc3Ryb2tlLXdpZHRoPSIxIi8+PC9wYXR0ZXJuPjwvZGVmcz48cmVjdCB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiBmaWxsPSJ1cmwoI2dyaWQpIi8+PC9zdmc+')] opacity-40"></div>

        <div class="relative max-w-7xl mx-auto text-center">
            <div class="inline-flex items-center space-x-2 px-4 py-2 rounded-full glass-effect mb-8">
                <span class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span>
                <span class="text-sm text-gray-300">Professional YouTube Chat Automation</span>
            </div>

            <h1 class="text-5xl sm:text-6xl lg:text-7xl font-bold mb-6 leading-tight">
                <span class="bg-gradient-to-r from-white via-purple-200 to-indigo-200 bg-clip-text text-transparent">
                    Automate & Moderate<br/>Your YouTube Live Chat
                </span>
            </h1>

            <p class="text-xl sm:text-2xl text-gray-400 mb-12 max-w-3xl mx-auto leading-relaxed">
                Professional chat automation bot for YouTube streamers. AI-powered responses, custom commands, smart moderation, and real-time analytics—all in one platform.
            </p>

            <div class="flex flex-col sm:flex-row items-center justify-center gap-4 mb-16">
                @auth
                    <a href="{{ route('dashboard') }}" class="w-full sm:w-auto px-8 py-4 bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-500 hover:to-indigo-500 rounded-xl font-semibold text-lg transition-all shadow-2xl shadow-purple-500/50 hover:shadow-purple-500/70 hover:scale-105">
                        Go to Dashboard
                    </a>
                @else
                    <a href="{{ route('login') }}" class="w-full sm:w-auto px-8 py-4 bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-500 hover:to-indigo-500 rounded-xl font-semibold text-lg transition-all shadow-2xl shadow-purple-500/50 hover:shadow-purple-500/70 hover:scale-105">
                        Sign in with Google
                    </a>
                @endauth
                <a href="#features" class="w-full sm:w-auto px-8 py-4 glass-effect hover:bg-white/5 rounded-xl font-semibold text-lg transition-all">
                    Learn More
                </a>
            </div>

            <!-- Stats -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 max-w-4xl mx-auto">
                <div class="glass-effect rounded-2xl p-6">
                    <div class="text-3xl font-bold bg-gradient-to-r from-purple-400 to-indigo-400 bg-clip-text text-transparent mb-2">50+</div>
                    <div class="text-sm text-gray-400">Languages Supported</div>
                </div>
                <div class="glass-effect rounded-2xl p-6">
                    <div class="text-3xl font-bold bg-gradient-to-r from-purple-400 to-indigo-400 bg-clip-text text-transparent mb-2">24/7</div>
                    <div class="text-sm text-gray-400">Automated Operation</div>
                </div>
                <div class="glass-effect rounded-2xl p-6">
                    <div class="text-3xl font-bold bg-gradient-to-r from-purple-400 to-indigo-400 bg-clip-text text-transparent mb-2">AI</div>
                    <div class="text-sm text-gray-400">Powered Responses</div>
                </div>
                <div class="glass-effect rounded-2xl p-6">
                    <div class="text-3xl font-bold bg-gradient-to-r from-purple-400 to-indigo-400 bg-clip-text text-transparent mb-2">Free</div>
                    <div class="text-sm text-gray-400">To Get Started</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-20 px-4 sm:px-6 lg:px-8 bg-gradient-to-b from-gray-950 to-gray-900">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-16">
                <h2 class="text-4xl sm:text-5xl font-bold mb-4">
                    <span class="bg-gradient-to-r from-white to-gray-300 bg-clip-text text-transparent">
                        Powerful Features for Streamers
                    </span>
                </h2>
                <p class="text-xl text-gray-400 max-w-2xl mx-auto">
                    Everything you need to manage your YouTube live chat professionally
                </p>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- Feature 1: AI Responses -->
                <div class="feature-card glass-effect rounded-2xl p-8 hover:border-purple-500/50">
                    <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">AI-Powered Responses</h3>
                    <p class="text-gray-400 leading-relaxed mb-4">
                        Intelligent, context-aware responses using OpenAI's GPT models. Automatically detects questions and responds in 50+ languages with natural, human-like conversation.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-500">
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Context-aware understanding</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Multilingual support</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Customizable personality</span>
                        </li>
                    </ul>
                </div>

                <!-- Feature 2: Custom Commands -->
                <div class="feature-card glass-effect rounded-2xl p-8 hover:border-purple-500/50">
                    <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Custom Commands</h3>
                    <p class="text-gray-400 leading-relaxed mb-4">
                        Create unlimited custom commands with personalized responses. Perfect for FAQs, social links, schedules, and more. Easy-to-use interface with cooldown control.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-500">
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Unlimited commands</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Cooldown management</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Easy to configure</span>
                        </li>
                    </ul>
                </div>

                <!-- Feature 3: Smart Moderation -->
                <div class="feature-card glass-effect rounded-2xl p-8 hover:border-purple-500/50">
                    <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Smart Moderation</h3>
                    <p class="text-gray-400 leading-relaxed mb-4">
                        Automated content moderation with customizable banned keywords. Automatically timeout or ban users who violate your chat rules. Keep your community safe.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-500">
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Banned keyword detection</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Auto timeout/ban</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Custom rules</span>
                        </li>
                    </ul>
                </div>

                <!-- Feature 4: Spam Protection -->
                <div class="feature-card glass-effect rounded-2xl p-8 hover:border-purple-500/50">
                    <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Spam Protection</h3>
                    <p class="text-gray-400 leading-relaxed mb-4">
                        User cooldown system prevents chat spam and command abuse. Configurable cooldown periods ensure fair usage and maintain chat quality.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-500">
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Per-user cooldowns</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Configurable limits</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Anti-abuse protection</span>
                        </li>
                    </ul>
                </div>

                <!-- Feature 5: Timers & Greetings -->
                <div class="feature-card glass-effect rounded-2xl p-8 hover:border-purple-500/50">
                    <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Timers & Greetings</h3>
                    <p class="text-gray-400 leading-relaxed mb-4">
                        Schedule automated messages at intervals or based on chat activity. Automatically greet new viewers and recognize returning subscribers.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-500">
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Time-based timers</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Activity-based triggers</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Auto viewer greetings</span>
                        </li>
                    </ul>
                </div>

                <!-- Feature 6: Analytics -->
                <div class="feature-card glass-effect rounded-2xl p-8 hover:border-purple-500/50">
                    <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Real-Time Analytics</h3>
                    <p class="text-gray-400 leading-relaxed mb-4">
                        Track chat engagement with detailed statistics. Message counts, command usage, moderation actions, and more—all in real-time.
                    </p>
                    <ul class="space-y-2 text-sm text-gray-500">
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Message statistics</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Command usage tracking</span>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-5 h-5 text-purple-400 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <span>Engagement metrics</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works Section -->
    <section id="how-it-works" class="py-20 px-4 sm:px-6 lg:px-8 bg-gray-950">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-16">
                <h2 class="text-4xl sm:text-5xl font-bold mb-4">
                    <span class="bg-gradient-to-r from-white to-gray-300 bg-clip-text text-transparent">
                        Get Started in Minutes
                    </span>
                </h2>
                <p class="text-xl text-gray-400 max-w-2xl mx-auto">
                    Simple setup process to automate your YouTube live chat
                </p>
            </div>

            <div class="grid md:grid-cols-5 gap-8">
                <!-- Step 1 -->
                <div class="text-center">
                    <div class="relative mb-6">
                        <div class="step-number w-16 h-16 rounded-2xl flex items-center justify-center text-2xl font-bold text-white mx-auto shadow-lg shadow-purple-500/50">
                            1
                        </div>
                        <div class="hidden md:block absolute top-8 left-1/2 w-full h-0.5 bg-gradient-to-r from-purple-500 to-transparent -z-10"></div>
                    </div>
                    <h3 class="text-xl font-bold mb-3 text-white">Sign in with Google</h3>
                    <p class="text-gray-400">
                        Authenticate securely using your Google account
                    </p>
                </div>

                <!-- Step 2 -->
                <div class="text-center">
                    <div class="relative mb-6">
                        <div class="step-number w-16 h-16 rounded-2xl flex items-center justify-center text-2xl font-bold text-white mx-auto shadow-lg shadow-purple-500/50">
                            2
                        </div>
                        <div class="hidden md:block absolute top-8 left-1/2 w-full h-0.5 bg-gradient-to-r from-purple-500 to-transparent -z-10"></div>
                    </div>
                    <h3 class="text-xl font-bold mb-3 text-white">Grant Permissions</h3>
                    <p class="text-gray-400">
                        Allow Daybot to access your YouTube live chat
                    </p>
                </div>

                <!-- Step 3 -->
                <div class="text-center">
                    <div class="relative mb-6">
                        <div class="step-number w-16 h-16 rounded-2xl flex items-center justify-center text-2xl font-bold text-white mx-auto shadow-lg shadow-purple-500/50">
                            3
                        </div>
                        <div class="hidden md:block absolute top-8 left-1/2 w-full h-0.5 bg-gradient-to-r from-purple-500 to-transparent -z-10"></div>
                    </div>
                    <h3 class="text-xl font-bold mb-3 text-white">Configure Bot</h3>
                    <p class="text-gray-400">
                        Set up commands, moderation rules, and preferences
                    </p>
                </div>

                <!-- Step 4 -->
                <div class="text-center">
                    <div class="relative mb-6">
                        <div class="step-number w-16 h-16 rounded-2xl flex items-center justify-center text-2xl font-bold text-white mx-auto shadow-lg shadow-purple-500/50">
                            4
                        </div>
                        <div class="hidden md:block absolute top-8 left-1/2 w-full h-0.5 bg-gradient-to-r from-purple-500 to-transparent -z-10"></div>
                    </div>
                    <h3 class="text-xl font-bold mb-3 text-white">Start Your Bot</h3>
                    <p class="text-gray-400">
                        Launch the bot for your YouTube channel
                    </p>
                </div>

                <!-- Step 5 -->
                <div class="text-center">
                    <div class="relative mb-6">
                        <div class="step-number w-16 h-16 rounded-2xl flex items-center justify-center text-2xl font-bold text-white mx-auto shadow-lg shadow-purple-500/50">
                            5
                        </div>
                    </div>
                    <h3 class="text-xl font-bold mb-3 text-white">Go Live!</h3>
                    <p class="text-gray-400">
                        Your bot automatically manages chat when you stream
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Data Usage & Transparency Section -->
    <section id="data-usage" class="py-20 px-4 sm:px-6 lg:px-8 bg-gradient-to-b from-gray-900 to-gray-950">
        <div class="max-w-7xl mx-auto">
            <div class="text-center mb-16">
                <div class="inline-flex items-center space-x-2 px-4 py-2 rounded-full glass-effect mb-6">
                    <svg class="w-5 h-5 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                    </svg>
                    <span class="text-sm text-gray-300">Google OAuth Verified</span>
                </div>

                <h2 class="text-4xl sm:text-5xl font-bold mb-4">
                    <span class="bg-gradient-to-r from-white to-gray-300 bg-clip-text text-transparent">
                        YouTube Data Usage & Privacy
                    </span>
                </h2>
                <p class="text-xl text-gray-400 max-w-3xl mx-auto">
                    We believe in complete transparency about how we access and use your YouTube data
                </p>
            </div>

            <div class="grid lg:grid-cols-2 gap-8 mb-12">
                <!-- What We Access -->
                <div class="glass-effect rounded-2xl p-8">
                    <div class="flex items-center mb-6">
                        <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-500 to-cyan-600 flex items-center justify-center mr-4">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </div>
                        <h3 class="text-2xl font-bold text-white">What We Access</h3>
                    </div>
                    <ul class="space-y-4">
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Your YouTube Channel Info:</span>
                                <span class="text-gray-400"> Channel name, ID, handle, and profile picture</span>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Live Chat Messages:</span>
                                <span class="text-gray-400"> Messages posted in your live stream chat by viewers</span>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Chat Participant Info:</span>
                                <span class="text-gray-400"> Usernames and user IDs of chat participants</span>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Live Broadcast Details:</span>
                                <span class="text-gray-400"> Active broadcast ID and live chat ID</span>
                            </div>
                        </li>
                    </ul>
                </div>

                <!-- Why We Need It -->
                <div class="glass-effect rounded-2xl p-8">
                    <div class="flex items-center mb-6">
                        <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-purple-500 to-pink-600 flex items-center justify-center mr-4">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <h3 class="text-2xl font-bold text-white">Why We Need It</h3>
                    </div>
                    <ul class="space-y-4">
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Verify Your Identity:</span>
                                <span class="text-gray-400"> Display your channel name and ensure bot operates on correct channel</span>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Read Chat Messages:</span>
                                <span class="text-gray-400"> Monitor what viewers are saying to trigger responses and commands</span>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Send Responses:</span>
                                <span class="text-gray-400"> Post automated replies, commands, AI messages, and timer messages</span>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <svg class="w-6 h-6 text-purple-400 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            <div>
                                <span class="font-semibold text-white">Moderate Chat:</span>
                                <span class="text-gray-400"> Enforce chat rules, timeout/ban violators, and keep your community safe</span>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Privacy Commitments -->
            <div class="glass-effect rounded-2xl p-8 mb-8">
                <h3 class="text-2xl font-bold mb-6 text-white flex items-center">
                    <svg class="w-8 h-8 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                    </svg>
                    Our Privacy Commitments
                </h3>
                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-red-500 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M13.477 14.89A6 6 0 015.11 6.524l8.367 8.368zm1.414-1.414L6.524 5.11a6 6 0 018.367 8.367zM18 10a8 8 0 11-16 0 8 8 0 0116 0z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <p class="font-semibold text-white">We DO NOT sell your data</p>
                            <p class="text-sm text-gray-400">Never shared with advertisers</p>
                        </div>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-red-500 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M13.477 14.89A6 6 0 015.11 6.524l8.367 8.368zm1.414-1.414L6.524 5.11a6 6 0 018.367 8.367zM18 10a8 8 0 11-16 0 8 8 0 0116 0z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <p class="font-semibold text-white">We DO NOT share with third parties</p>
                            <p class="text-sm text-gray-400">Except OpenAI for AI features</p>
                        </div>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-red-500 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M13.477 14.89A6 6 0 015.11 6.524l8.367 8.368zm1.414-1.414L6.524 5.11a6 6 0 018.367 8.367zM18 10a8 8 0 11-16 0 8 8 0 0116 0z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <p class="font-semibold text-white">We DO NOT store sensitive data</p>
                            <p class="text-sm text-gray-400">Only necessary for service</p>
                        </div>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <p class="font-semibold text-white">You can revoke access anytime</p>
                            <p class="text-sm text-gray-400">Through Google Account settings</p>
                        </div>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <p class="font-semibold text-white">We ONLY read live chat</p>
                            <p class="text-sm text-gray-400">No access to private content</p>
                        </div>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-green-500 mr-3 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <p class="font-semibold text-white">Transparent data usage</p>
                            <p class="text-sm text-gray-400">Full privacy policy available</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Third Party Services -->
            <div class="grid md:grid-cols-2 gap-6 mb-8">
                <div class="glass-effect rounded-2xl p-6 border-l-4 border-blue-500">
                    <h4 class="font-bold text-white mb-2 flex items-center">
                        <svg class="w-5 h-5 text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z" />
                        </svg>
                        OpenAI API (Optional)
                    </h4>
                    <p class="text-sm text-gray-400">
                        Chat messages are sent to OpenAI's GPT models to generate intelligent responses when AI features are enabled. You can disable this anytime. OpenAI does not use API data to train their models.
                    </p>
                </div>

                <div class="glass-effect rounded-2xl p-6 border-l-4 border-red-500">
                    <h4 class="font-bold text-white mb-2 flex items-center">
                        <svg class="w-5 h-5 text-red-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M12.395 2.553a1 1 0 00-1.45-.385c-.345.23-.614.558-.822.88-.214.33-.403.713-.57 1.116-.334.804-.614 1.768-.84 2.734a31.365 31.365 0 00-.613 3.58 2.64 2.64 0 01-.945-1.067c-.328-.68-.398-1.534-.398-2.654A1 1 0 005.05 6.05 6.981 6.981 0 003 11a7 7 0 1011.95-4.95c-.592-.591-.98-.985-1.348-1.467-.363-.476-.724-1.063-1.207-2.03zM12.12 15.12A3 3 0 017 13s.879.5 2.5.5c0-1 .5-4 1.25-4.5.5 1 .786 1.293 1.371 1.879A2.99 2.99 0 0113 13a2.99 2.99 0 01-.879 2.121z" clip-rule="evenodd" />
                        </svg>
                        YouTube API Services
                    </h4>
                    <p class="text-sm text-gray-400">
                        All YouTube interactions are governed by <a href="https://www.youtube.com/t/terms" target="_blank" class="text-purple-400 hover:text-purple-300 underline">YouTube Terms of Service</a> and <a href="https://www.google.com/policies/privacy" target="_blank" class="text-purple-400 hover:text-purple-300 underline">Google Privacy Policy</a>.
                    </p>
                </div>
            </div>

            <!-- Revoke Access Instructions -->
            <div class="glass-effect rounded-2xl p-8 border border-purple-500/30">
                <h3 class="text-xl font-bold mb-4 text-white">How to Revoke Access</h3>
                <p class="text-gray-400 mb-4">You can revoke Daybot's access to your YouTube data at any time:</p>
                <ol class="space-y-3 text-gray-300">
                    <li class="flex items-start">
                        <span class="flex-shrink-0 w-6 h-6 rounded-full bg-purple-600 text-white text-sm flex items-center justify-center mr-3 mt-0.5">1</span>
                        <span>Visit your <a href="https://myaccount.google.com/permissions" target="_blank" class="text-purple-400 hover:text-purple-300 underline">Google Account Permissions page</a></span>
                    </li>
                    <li class="flex items-start">
                        <span class="flex-shrink-0 w-6 h-6 rounded-full bg-purple-600 text-white text-sm flex items-center justify-center mr-3 mt-0.5">2</span>
                        <span>Find "Daybot" in the list of third-party apps</span>
                    </li>
                    <li class="flex items-start">
                        <span class="flex-shrink-0 w-6 h-6 rounded-full bg-purple-600 text-white text-sm flex items-center justify-center mr-3 mt-0.5">3</span>
                        <span>Click "Remove Access" to immediately revoke all permissions</span>
                    </li>
                </ol>
            </div>
        </div>
    </section>

    <!-- Final CTA Section -->
    <section class="py-20 px-4 sm:px-6 lg:px-8 bg-gradient-to-br from-purple-900/20 via-gray-950 to-indigo-900/20">
        <div class="max-w-4xl mx-auto text-center">
            <h2 class="text-4xl sm:text-5xl font-bold mb-6">
                <span class="bg-gradient-to-r from-white via-purple-200 to-indigo-200 bg-clip-text text-transparent">
                    Ready to Automate Your YouTube Chat?
                </span>
            </h2>
            <p class="text-xl text-gray-400 mb-10">
                Join streamers who trust Daybot to manage their live chat professionally. Get started in minutes—no credit card required.
            </p>
            @auth
                <a href="{{ route('dashboard') }}" class="inline-block px-10 py-5 bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-500 hover:to-indigo-500 rounded-xl font-semibold text-xl transition-all shadow-2xl shadow-purple-500/50 hover:shadow-purple-500/70 hover:scale-105">
                    Go to Dashboard →
                </a>
            @else
                <a href="{{ route('login') }}" class="inline-block px-10 py-5 bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-500 hover:to-indigo-500 rounded-xl font-semibold text-xl transition-all shadow-2xl shadow-purple-500/50 hover:shadow-purple-500/70 hover:scale-105">
                    Sign in with Google →
                </a>
            @endauth
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-950 border-t border-white/5 py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-7xl mx-auto">
            <div class="grid md:grid-cols-4 gap-8 mb-8">
                <!-- Brand -->
                <div class="md:col-span-1">
                    <div class="flex items-center space-x-3 mb-4">
                        <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-purple-500 to-indigo-600 flex items-center justify-center">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                            </svg>
                        </div>
                        <span class="text-xl font-bold bg-gradient-to-r from-purple-400 to-indigo-400 bg-clip-text text-transparent">Daybot</span>
                    </div>
                    <p class="text-gray-400 text-sm">
                        Professional YouTube live chat automation and moderation for streamers.
                    </p>
                </div>

                <!-- Product -->
                <div>
                    <h4 class="font-semibold text-white mb-4">Product</h4>
                    <ul class="space-y-2 text-sm text-gray-400">
                        <li><a href="#features" class="hover:text-purple-400 transition-colors">Features</a></li>
                        <li><a href="#how-it-works" class="hover:text-purple-400 transition-colors">How It Works</a></li>
                        <li><a href="#data-usage" class="hover:text-purple-400 transition-colors">Data & Privacy</a></li>
                        @auth
                            <li><a href="{{ route('dashboard') }}" class="hover:text-purple-400 transition-colors">Dashboard</a></li>
                        @endauth
                    </ul>
                </div>

                <!-- Legal -->
                <div>
                    <h4 class="font-semibold text-white mb-4">Legal</h4>
                    <ul class="space-y-2 text-sm text-gray-400">
                        <li><a href="{{ route('privacy-policy') }}" class="hover:text-purple-400 transition-colors">Privacy Policy</a></li>
                        <li><a href="{{ route('terms-of-service') }}" class="hover:text-purple-400 transition-colors">Terms of Service</a></li>
                        <li><a href="https://www.youtube.com/t/terms" target="_blank" class="hover:text-purple-400 transition-colors">YouTube ToS</a></li>
                        <li><a href="https://policies.google.com/privacy" target="_blank" class="hover:text-purple-400 transition-colors">Google Privacy</a></li>
                    </ul>
                </div>

                <!-- Resources -->
                <div>
                    <h4 class="font-semibold text-white mb-4">Resources</h4>
                    <ul class="space-y-2 text-sm text-gray-400">
                        <li><a href="mailto:support@daybot.tv" class="hover:text-purple-400 transition-colors">Support</a></li>
                        <li><a href="https://developers.google.com/terms/api-services-user-data-policy" target="_blank" class="hover:text-purple-400 transition-colors">Google API Policy</a></li>
                    </ul>
                </div>
            </div>

            <!-- Bottom Bar -->
            <div class="border-t border-white/5 pt-8 flex flex-col md:flex-row justify-between items-center text-sm text-gray-400">
                <p>&copy; 2025 Daybot. All rights reserved. Official Domain: <span class="text-purple-400">daybot.tv</span></p>
                <p class="mt-4 md:mt-0">
                    Daybot uses <a href="https://developers.google.com/youtube/terms/api-services-terms-of-service" target="_blank" class="text-purple-400 hover:text-purple-300 underline">YouTube API Services</a>
                </p>
            </div>
        </div>
    </footer>

    <script>
        // Mobile menu toggle
        function toggleMobileMenu() {
            const menu = document.getElementById('mobileMenu');
            menu.classList.toggle('hidden');
        }

        // Smooth scroll
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    // Close mobile menu if open
                    document.getElementById('mobileMenu').classList.add('hidden');
                }
            });
        });
    </script>
</body>
</html>
