<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Auth\GoogleOAuthController;

// Login page
Route::get('/login', function () {
    return view('auth.login');
})->name('login')->middleware('guest');

// Email/Password Login - DISABLED (Only Google OAuth allowed)
// Route::post('/login', function (Request $request) {
//     $credentials = $request->validate([
//         'email' => ['required', 'email'],
//         'password' => ['required'],
//     ]);
//
//     if (Auth::attempt($credentials, $request->filled('remember'))) {
//         $request->session()->regenerate();
//         return redirect()->intended('/dashboard');
//     }
//
//     return back()->withErrors([
//         'email' => 'The provided credentials do not match our records.',
//     ])->onlyInput('email');
// })->middleware('guest');

// Google OAuth routes - No middleware restriction for flexibility
Route::prefix('oauth/google')->name('oauth.google.')->group(function () {
    Route::get('redirect', [GoogleOAuthController::class, 'redirect'])->name('redirect');
    Route::get('callback', [GoogleOAuthController::class, 'callback'])->name('callback');
});

// Logout route
Route::post('/logout', function (Request $request) {
    Auth::logout();
    $request->session()->invalidate();
    $request->session()->regenerateToken();
    return redirect('/');
})->name('logout');
