<?php

use App\Jobs\FireTimer;
use App\Jobs\PollYouTubeChat;
use App\Jobs\RefreshYouTubeToken;
use App\Models\OauthToken;
use App\Models\Tenant;
use App\Models\Timer;
use Illuminate\Support\Facades\Schedule;

// Poll YouTube chat for running tenants every 2 seconds
Schedule::call(function () {
    $tenants = Tenant::where('status', 'running')->get();
    foreach ($tenants as $tenant) {
        PollYouTubeChat::dispatch($tenant);
    }
})->everyTwoSeconds()->name('poll-youtube-chats');

// Fire timers every minute
Schedule::call(function () {
    $timers = Timer::where('is_enabled', true)
        ->whereHas('tenant', function ($query) {
            $query->where('status', 'running');
        })
        ->get();

    foreach ($timers as $timer) {
        FireTimer::dispatch($timer);
    }
})->everyMinute()->name('fire-timers');

// Refresh expiring tokens every 10 minutes
Schedule::call(function () {
    $tokens = OauthToken::where('expires_at', '<=', now()->addMinutes(30))
        ->whereNotNull('refresh_token')
        ->get();

    foreach ($tokens as $token) {
        RefreshYouTubeToken::dispatch($token);
    }
})->everyTenMinutes()->name('refresh-tokens');

// Cleanup old message logs (keep 7 days)
Schedule::command('model:prune', ['--model' => 'App\\Models\\MessageLog'])
    ->daily()
    ->name('prune-message-logs');

// Cleanup old audits (keep 30 days)
Schedule::command('model:prune', ['--model' => 'App\\Models\\Audit'])
    ->daily()
    ->name('prune-audits');
